#include "HTTPFile.h"

HTTPFile::HTTPFile(char* filename) {
    file = fopen(filename, "w");    
}

void HTTPFile::close() {
    if (file) {
        fclose(file);    
    }        
}

void HTTPFile::writeReset() {
    if (file) {
        rewind(file);   
    }
}

int HTTPFile::write(const char* buf, size_t len) {
    if (file) {
        len = fwrite(buf, 1, len, file);    
        if ((!m_chunked && (ftell(file) >= m_len)) || (m_chunked && !len)) {
            close();
        }
    }
    return len;    
}

void HTTPFile::setDataType(const char* type) {

}

void HTTPFile::setIsChunked(bool chunked) {
    m_chunked = chunked;
}

void HTTPFile::setDataLen(size_t len) {
    m_len = len;
}