
#define DEBUG
#include "logger.h"
/** fcopy: Copies a file
 *            Checks to ensure destination file was created.
 *            Returns -1 = error; 0 = success
 */
int fcopy (const char *src, const char *dst) { 
    FILE *fpsrc = fopen(src, "r");
    FILE *fpdst = fopen(dst, "w");
    int ch = fgetc(fpsrc);
    while (ch != EOF) {
        fputc(ch, fpdst);  
        ch = fgetc(fpsrc);   
    }
    fclose(fpsrc);  
    fclose(fpdst);   
    int retval = 0;
    fpdst = fopen(dst, "r");
    if (fpdst == NULL) {
        retval = 0;
    } else {
        fclose(fpdst); 
        retval = 1;
    }
    return retval;
}

/** frename: renames a file (via copy & delete).
 *    Moves data instead of adjusting the file name in the
 *    file directory. Checks to ensure the file was renamed.
 *    Returns -1 = error; 0 = success
 */
int frename(const char *oldfname, const char *newfname) {
    int retval = -1;
    INFO("Renaming");
    if (fcopy(oldfname, newfname)) {
        INFO("Deleting");
        remove(oldfname);    
        retval = 0;
    }     
    INFO("Done");
    return retval;
}