#include "mbed.h"
#include <string>

#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"
#include "F746_GUI.hpp"
#define Seuil 0.9

#define SeuilMinTimeP 70
#define SeuilMaxTimeP 250

#define SeuilMaxTimeEL 600
#define SeuilMAXTimeEM 2000

bool etat_precedent;
int TabTemps[100];

char morse[100];
int index_morse = 0;
int check = 1;
int flagBPReco = 0;

using namespace std;

//Déclaration de la base de donnée morse

static char *ListCara[36]=  {".-",
                             "-...",
                             "-.-.",
                             "-..",
                             ".",
                             "..-.",
                             "--.",
                             "....",
                             "..",
                             ".---",
                             "-.-",
                             ".-..",
                             "--",
                             "-.",
                             "---",
                             ".--.",
                             "--.-",
                             ".-.",
                             "...",
                             "-",
                             "..-",
                             "...-",
                             ".--",
                             "-..-",
                             "-.--",
                             "--..",
                             ".----",
                             "..---",
                             "...--",
                             "....-",
                             ".....",
                             "-....",
                             "--...",
                             "---..",
                             "----.",
                             "-----"
                            };

char ListLettre[36]= {'a',
                      'b',
                      'c',
                      'd',
                      'e',
                      'f',
                      'g',
                      'h',
                      'i',
                      'j',
                      'k',
                      'l',
                      'm',
                      'n',
                      'o',
                      'p',
                      'q',
                      'r',
                      's',
                      't',
                      'u',
                      'v',
                      'w',
                      'x',
                      'y',
                      'z',
                      '1',
                      '2',
                      '3',
                      '4',
                      '5',
                      '6',
                      '7',
                      '8',
                      '9',
                      '0'
                     };


Timer t;
DigitalOut led(LED1);
AnalogIn AnaIn(PF_10);
DigitalIn BP(USER_BUTTON);
Serial pc(USBTX, USBRX); // tx, rx

TS_DISCO_F746NG ts;
LCD_DISCO_F746NG lcd;

//Bouton utilisés pour le control du convertisseur morse
// Pour les couleurs, dans l'ordre on a la couleur du text, la couleure du fond d'écran et la couleur du bouton
Button Commencer(50,100,100,100,"BEGIN",Font12,LCD_COLOR_BLACK,LCD_COLOR_BLUE,LCD_COLOR_WHITE); 
Button Arrete(195,100,100,100,"STOP",Font12,LCD_COLOR_BLACK,LCD_COLOR_BLUE,LCD_COLOR_WHITE);
Button Recommencer(340,100,100,100,"RESTART",Font12,LCD_COLOR_BLACK,LCD_COLOR_BLUE,LCD_COLOR_WHITE);


int main()
{
    float LDR;
    bool etat;
    int index_TabTemps = 0;
    int index_Temps = 0;
    int index_TabCara = 0;
    int i, Temps[100][2];
    lcd.SetTextColor(LCD_COLOR_BLACK);
    
    unsigned char morse_decode[200];
    int index_morse_decode = 0;
    char cara[6];
    int index_cara=0;
    etat_precedent = false;
    
    t.start();
    while(Commencer.Touched()!=true);// On clique sur la touche "commencer" pour commencer l'enregistrement
    
    lcd.DisplayStringAt(0,LINE(1),(uint8_t *)"En cours...",CENTER_MODE);
    while(1) {
        
        LDR= AnaIn.read(); // Lecture de la valeur analogique
        pc.printf("LDR = %.2f\n\r",LDR);
        if(LDR>Seuil) { //Si la valeur analogique dépasse le seuil, cela veut dire que la lumière est détecter sinon pas de lumière
           
            etat = true;
            
        }

        else

        {
            etat = false;
            
        }

        if(etat !=etat_precedent) { // Si l'état actuel est différent de l'état précédent
            pc.printf("get time\n\r");
            TabTemps[index_TabTemps]= t.read_ms(); // Lecture du temps
            index_TabTemps++;
            // On indique ici si le temps stocké précédement était une partie du code morse ou pas
            if(etat==true) {
                Temps[index_Temps][0] = 1; 
                index_Temps++;
            } else {
                Temps[index_Temps][0] = 0;
                index_Temps++;
            }

        } else {
            pc.printf("no\n\r");

        }
        etat_precedent = etat;

        if(Arrete.Touched()==true) { // Si la touche "Arreter est apuyer, on arrete l'enregistrement pour passer au décodage
            
            
            lcd.ClearStringLine(1);
            
            //ici, on récupère tous les temps qu'on a lus pour optenir les temps correspondant au code morse
            for( i = 0; i<index_TabTemps; i++) {
                Temps[i][1] = TabTemps[i+1] - TabTemps[i];
            }
            
            
            for( i = 0; i<index_Temps; i++) {
                // On vérifie chaque temps correspondant à un bout du code morse pour savoir si c'était un point ou un tirait
                if(Temps[i][0] ==1) {
                    if(Temps[i][1]<SeuilMaxTimeP) {
                        morse[index_TabCara] =  '.';

                        pc.printf("%c",morse[index_TabCara]);
                        index_TabCara++;
                    } else {
                        morse[index_TabCara] =  '-';

                        pc.printf("%c",morse[index_TabCara]);
                        index_TabCara++;
                    }
                } else {
                    //Si le temps ne correspondait pas à bout du code morse, trois cas de figure se présente à nous : 
                    if(Temps[i][1]<SeuilMaxTimeP) {
                        //Ici, on  ne fait rien. Cela veut dire que le caractère n'est pas encore complet
                    } else if(Temps[i][1]<SeuilMaxTimeEL) {
                        morse[index_TabCara] = '*';
                        index_TabCara++;
                        //Ici, cela veut dire que le temps correspond à un espacemeent entre deux lettres. Donc on ajoute une étoile pour marquer la fin du caractère
                    } else if (Temps[i][1]<SeuilMAXTimeEM) {

                        morse[index_TabCara] =  ' ';
                        index_TabCara++;
                        //Ici, cela signifie que le mot est terminé. On met donc un espace pour pouvoir decoder le prochain mot.

                    }
                }
            }
            morse[index_TabCara]+='*';
            index_TabCara++;
            pc.printf("%d\n\r",index_TabCara);

            pc.printf("code morse : %s\n\r",morse);
            
            //Nous procédons ici au decodage lettre par lettre 

            for(i=0; i<index_TabCara; i++) {
                
                
                if(morse[i]== ' ') {
                    //Si le caractère rencontré est un espace, tu decode le code morse dans la variable cara qui correspond à un caractère
                    for(int j=0; j<36; j++) {
                        if(strcmp(ListCara[j], cara) == 0) {// On compare le code morse cara a notre basse de donnée. Si il reconnait le caractère, tu l'ajoutes à la chaine de caractère finale
                            morse_decode[index_morse_decode]= ListLettre[j];
                            index_morse_decode++;
                            check = 0;
                            
                        }
                    }
                    //Si il ne reconnait pas le caractère, alors tu ajoutes un point d'intérogation à ta chaine de caractère
                    if(check!=0) {
                        morse_decode[index_morse_decode]= '?';
                        index_morse_decode++;
                    }
                    //On remet à zero la variable 'cara' pour decoder le prochain caractère
                    for (int y=0;y<6;y++){
                        cara[y] = ' ';
                        
                        }
                    index_cara=0;
                    morse_decode[index_morse_decode]= ' ';
                    index_morse_decode++;
                    
                } else if(morse[i]=='*') {
                    //Si le caractère rencontré est une étoile, tu decode le code morse dans la variable cara qui correspond à un caractère
                    for(int j=0; j<36; j++) {
                        if(strcmp(ListCara[j], cara) == 0) {
                            morse_decode[index_morse_decode]= ListLettre[j];
                            index_morse_decode++;
                            
                            check = 0;
                            
                        }
                    }
                    if(check!=0) {
                        morse_decode[index_morse_decode]= '?';
                        index_morse_decode++;
                    }
                    for (int y=0;y<6;y++){
                        cara[y] = ' ';
                        index_cara=0;
                        }
                    
                } else {
                    cara[index_cara]= morse[i];
                    index_cara++;
                    cara[index_cara]='\0'; // c'est pour decoder la chaine de caractère
                    
                }

            }
            
            //On affiche le code decodé sur l'écran LCD
            lcd.DisplayStringAt(0,LINE(1),(uint8_t *)morse_decode,CENTER_MODE);
            flagBPReco =1;
            pc.printf("code converti : %s\n\r",morse_decode);
            
            

        }
        //On attend que la touche "recommencer" soit appuyer pour tout réinitialiser
        if(flagBPReco==1){
            while(Recommencer.Touched()!=true);
            //morse_decode = "";
            flagBPReco=0;
            index_TabCara=0;
            index_Temps=0;
            index_TabTemps=0;

            lcd.ClearStringLine(1);
            lcd.DisplayStringAt(0,LINE(1),(uint8_t *)"En cours...",CENTER_MODE);
            for(i = 0;i<index_morse_decode;i++){
                morse_decode[index_morse_decode]=0;
                }
            index_morse_decode=0;
            
        
            Recommencer.Activate();
            Arrete.Activate(); 
        
           
        }
            
        

    }
}
