# Two way data using Multitech mDot

Demonstrates two-way data over LoRaWAN using Multitech mDot.

1. Triggers transmission when D6 goes high - this is the special wake-up pin on the mDot. Short D6 to test quickly.
2. The RX window is used to toggle D2. If 0x00 is received the pin goes high, if 0x01 is received the pin goes low (as the LEDs are inverted on the break-out board).

## Using this software with mbed Device Connector

1. Connect your gateway to LORIOT EU1.
2. Go to http://apm-lora-eu2.cloudapp.net:5101 and click on 'Create new device'.
3. Paste in a security.h file from your Connector account.
4. Copy the keys over to ``main.cpp``.
5. Compile and flash, and verify that messages arrive.
6. Configure the device like this:
    * Resources:
        ```json
        {
            "button/0/clicks": {
                "mode": "r",
                "defaultValue": "0"
            },
            "led/0/value": {
                "mode": "w"
            }
        }
        ```
    * Process Data:
        ```js
        function (bytes) {
            return {
                "button/0/clicks": (bytes[0] << 8) + bytes[1]
            };
        }
        ```
    * Write Data:
        ```js
        {
            "led/0/value": function (v) {
                return { port: 2, data: [ Number(v) ? 0x1 : 0x0 ] };
            }
        }
        ```
7. Click 'Save'.
