#include "mbed.h"

I2C i2c(p28, p27);
 
const int addr = 0x90;

Serial pc(USBTX, USBRX); // tx, rx

BusOut myleds(LED1, LED2, LED3, LED4);

int writereg(int reg,int val)
{
    i2c.start();
    i2c.write(addr);
    i2c.write(reg <<3); 
    int aa=i2c.write(val);
    i2c.stop();
    return(aa);
}   
int readreg(int reg)
{
    i2c.start();
    i2c.write(addr);
    i2c.write(reg <<3); 
    i2c.start();
    i2c.write(addr|1);
    int aa=i2c.read(0); //0=nack
    i2c.stop();
    return(aa);
}
     

int main()
{
    {
        int bb;
        i2c.start();
        bb=i2c.write(addr);
        i2c.stop();
        pc.putc(48+bb);
        writereg(0x03,0x83); //LCR
        writereg(0x00,24);   //DLL
        writereg(0x01,00);   //DLH
        bb=readreg(0x00);    //DLL
        bb|=readreg(1)<<8;   //DLH
        pc.printf("baud %d ",bb);
        writereg(0x03,0x03); //LCR
  //      writereg(0x02,0x01); //FCR
        pc.printf("lsr: %d ",readreg(0x05)); //LSR
        while(1)
        {
            int aa=readreg(0x05); //LSR
            if ((aa & 0x20) && pc.readable())
            {
                writereg(0x00,pc.getc()); //THR
                //pc.printf("fifo: %d",readreg(0x08)); //TXLVL
            }
            if ((aa & 0x01) && pc.writeable())
            {
                pc.putc(readreg(0x00)); //RHR
                
            }
        }
            
        
        
    }
    

}
    