#include "mbed.h"
/** @file main.cpp
 *
 * Serial controlled AD9851 demo
 * Mainly intended for DDS60 board but should be adaptable by changing XTAL
 * Note uses a software serial protocol resembling SPI(0)
 * AD9851 is LSB first and is believed to still accept clocks when LOAD is high
 * Initial start up is odd due to need to leave parallel mode, and to prevent 
 * loading junk if the device is already in serial mode the first "LOAD" must 
 * come after a valid serial word. In this case first 8 then 40 zeros are sent 
 * on program start
 *
 * Note using a high-idling select line and a high-idling clock but
 * according to datasheet both are rising-edge triggered
 */

#define xtal 180000000

DigitalOut mosi(p5);
DigitalOut sck(p7,1);
DigitalOut sel(p22,1); //default 1 to try to avoid false edges

///LSB-first serial send
void ssend(unsigned char count, unsigned int prog)
{
    
    while(count)
    {
        mosi=prog&1;     
        sck=0;
        wait_us(1);
        sck=1;
        wait_us(1);
        count--;
        prog=prog>>1;
    }
}        
    
/** calculate divisor value
 * calculates the sum frequency*(1<<32)/xtal
 * fails if frequency>xtal or if frequency > maxint
 */
unsigned int CalcFreq(unsigned int freq,unsigned int ref)
{
    unsigned char count;
    unsigned int result=0;
    for(count=0;count< 32;count++)
    {
      result = result << 1;
      freq=freq << 1;
      if (freq >= ref)
      {
        freq = freq - ref;
        result++;
      }
    }
    return(result);
} 
Serial pc(USBTX, USBRX); // tx, rx


int freq;
int prog;
char c;
int main() {
    // zero the AD9851 to prevent erroneous operation        
    sck=1;
    sel=0;
    ssend(8,0);
    sel=1;
    wait_us(1);
    sel=0;
    ssend(40,0);
    sel=1;

    while(1) 
    {
        pc.printf("AD9851 control\r\n");
        pc.printf("Enter Frequency\r\n");
        freq=0;
        c=0;
        while(c!=13) {
            c=pc.getc();
            if (c>=48 & c<58) {
                freq = freq*10 + c-48;
                pc.printf("\r%i",freq);
            } else {
                if (c==0x7f)
                {
                    freq = freq / 10;
                    pc.printf("\r%i \b",freq);
                }
            }
        }
        if (freq)
        {
            prog=CalcFreq(freq,xtal); //converts from MHz to internal control word
            pc.printf("\r\nControl word: 0x01%08x\r\n",prog);//
            sel=0;
            ssend(32,prog);
            ssend(8,0x01);
            sel=1;
        }
    }
}