#include "mbed.h"
// Use SPI port to write an 8 bit pattern to MIC5821 open collector driver device.
// MBED led1 lights if pattern read back from MIC5821 matches pattern written
// Ordinarily the device would be write-only but loopback may be usefull in testing.
// Cascade output is NOT tristate. Strobe is NOT a CS/SS signal, needs a pulse.
//
// Note that the MIC has a speed limit, 3.3MHz at 5v, mine works OK at 1MHz at 3.3v
// Also input has CMOS thresholds so it may not recognise MBED logic HI when powered
// from 5v so power it from Vout.
//
// Data is clocked in on rising edges so SPI 0,0 or SPI 1,1. 

SPI spi(p5, p6, p7); // mosi, miso, sclk

DigitalOut strobe(p21);
DigitalOut led(LED1);

int main() {
    spi.format(8,0);
    spi.frequency(1000000);
    char leds,prev;
    leds=0;
    while(1) {
        prev=spi.write(leds)+1;
        led=(prev == leds);
        leds++;
        strobe=1;
        wait_us(1);
        strobe=0;
        wait(0.5);
    }
}
