// Hello World! for the TextLCD
/*
 * Heavily modified LCD "Hello world"
 *
 * LCD Library has been merged into program for convenience of development, and
 * can be de-merged once its looking reliable
 * currently this gives good results with a small LCD and with a LCD emulation VFD
 * but is not reliable with a GU140x32-7806A graphic VFD
 *
 * Note E is set to 1 at end of cycle in an attempt to force a bug as display works fine
 * on first power-up but tends to corrupt after MBED manual reset. I am speculating that
 * something appears on MBED pins that the display "objects" to during a manual reset
 *
 */

#include "LCD_nonblocking.h"
DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
DigitalOut Led3(LED3);
DigitalOut Led4(LED4);


TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD20x4); // rs, e, d4-d7


int main()
{
    while(1) {
        Led1=1;
        lcd.init();
        Led2=1;
        Led1=0;
        while (lcd.busy) {}
        Led3=1;
        Led2=0;
        lcd.printf("Test String that goes over end of line!\n");
        Led4=1;
        Led3=0;
        while (lcd.busy) {}
        Led1=1;
        wait(1);
        // DigitalOut E(p17);
        // E=1; // try to break it
    }
}
