#include <SPI.h>
#include "Adafruit_GFX.h"
#include "Adafruit_GP9002.h"

#define _MOSI p5     // VFD PIN#12
#define _MISO p6     // VFD PIN#8
#define _CLK  p7     // VFD PIN#11
#define _CS   p8     // VFD PIN#13
#define _DC  p22     // VFD PIN#14
// connect VFD #15, #16, #17 to 5V
// connect VFD #9 #18 #19 #20 to ground
SPI SPIport(_MOSI,_MISO,_CLK);
Adafruit_GP9002 display = Adafruit_GP9002(SPIport, _CS, _DC);

// if using hardware SPI on an UNO or other classic Arduino, the pinouts are the same as
// above.
//Adafruit_GP9002 display = Adafruit_GP9002(_CS, _DC);

#ifndef min
#define min(a,b)                  ((a)<(b)?(a):(b))
#endif
#ifndef max
#define max(a,b)                  ((a)>(b)?(a):(b))
#endif


#define NUMFLAKES 10
#define XPOS 0
#define YPOS 1
#define DELTAY 2


#define LOGO16_GLCD_HEIGHT 16 
#define LOGO16_GLCD_WIDTH  16 
const unsigned char logo16_glcd_bmp[] =
{ 0b00000000, 0b11000000,
  0b00000001, 0b11000000,
  0b00000001, 0b11000000,
  0b00000011, 0b11100000,
  0b11110011, 0b11100000,
  0b11111110, 0b11111000,
  0b01111110, 0b11111111,
  0b00110011, 0b10011111,
  0b00011111, 0b11111100,
  0b00001101, 0b01110000,
  0b00011011, 0b10100000,
  0b00111111, 0b11100000,
  0b00111111, 0b11110000,
  0b01111100, 0b11110000,
  0b01110000, 0b01110000,
  0b00000000, 0b00110000 };

#include "adabmp.c"

extern const unsigned char BitReverseTable256[]; 


void testdrawbitmap(const uint8_t *bitmap, uint8_t w, uint8_t h) {
  uint8_t icons[NUMFLAKES][3];
  srand(666);     // whatever seed
 
  // initialize
  for (uint8_t f=0; f< NUMFLAKES; f++) {
    icons[f][XPOS] = rand() % display.width();
    icons[f][YPOS] = 0;
    icons[f][DELTAY] = rand() % 5 + 1;
    
/*    Serial.print("x: ");
    Serial.print(icons[f][XPOS], DEC);
    Serial.print(" y: ");
    Serial.print(icons[f][YPOS], DEC);
    Serial.print(" dy: ");
    Serial.println(icons[f][DELTAY], DEC);
*/  }

  while (1) {
    // draw each icon
    for (uint8_t f=0; f< NUMFLAKES; f++) {
      display.drawBitmap(icons[f][XPOS], icons[f][YPOS], logo16_glcd_bmp, w, h, WHITE);
    }
    wait_ms(200);
    
    // then erase it + move it
    for (uint8_t f=0; f< NUMFLAKES; f++) {
      display.drawBitmap(icons[f][XPOS], icons[f][YPOS],  logo16_glcd_bmp, w, h, BLACK);
      // move it
      icons[f][YPOS] += icons[f][DELTAY];
      // if its gone, reinit
      if (icons[f][YPOS] > display.height()) {
	icons[f][XPOS] = rand() % display.width();
	icons[f][YPOS] = 0;
	icons[f][DELTAY] = rand() % 5 + 1;
      }
    }
   }
}


void testdrawchar(void) {
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0,0);

  for (uint8_t i=0; i < 168; i++) {
    if (i == '\n') continue;
    display.putc(i);
    //if ((i > 0) && (i % 14 == 0))
      //display.println();
  }    
}

void testdrawcircle(void) {
  for (uint8_t i=0; i<display.height(); i+=2) {
    display.drawCircle(display.width()/2, display.height()/2, i, WHITE);
  }
}

void testfillrect(void) {
  uint8_t color = 1;
  for (uint8_t i=0; i<display.height()/2; i+=3) {
    // alternate colors
    display.fillRect(i, i, display.width()-i*2, display.height()-i*2, color%4);
    color++;
  }
}

void testdrawtriangle(void) {
  for (int16_t i=0; i<min(display.width(),display.height())/2; i+=5) {
    display.drawTriangle(display.width()/2, display.height()/2-i,
                     display.width()/2-i, display.height()/2+i,
                     display.width()/2+i, display.height()/2+i, WHITE);
  }
}

void testfilltriangle(void) {
  uint8_t color = 3;
  for (int16_t i=min(display.width(),display.height())/2; i>0; i-=5) {
    display.fillTriangle(display.width()/2, display.height()/2-i,
                     display.width()/2-i, display.height()/2+i,
                     display.width()/2+i, display.height()/2+i, color);
    if (color) color--;
    else color = 3;
  }
}

void testdrawroundrect(void) {
  for (uint8_t i=2; i<display.height()/4; i+=2) {
    display.drawRoundRect(i, i, display.width()-2*i, display.height()-2*i, display.height()/4, 3);
  }
}

void testfillroundrect(void) {
  uint8_t color = WHITE;
  for (uint8_t i=0; i<display.height()/4-2; i+=2) {
    display.fillRoundRect(i, i, display.width()-2*i, display.height()-2*i, display.height()/4, color);
    if (color) color--;
    else color = 3;
  }
}
   
void testdrawrect(void) {
  for (uint8_t i=0; i<display.height()/2; i+=2) {
    display.drawRect(i, i, display.width()-2*i, display.height()-2*i, WHITE);
  }
}

void testdrawline() {  
  for (uint8_t i=0; i<display.width(); i+=4) {
    display.drawLine(0, 0, i, display.height()-1, WHITE);
  }
  for (uint8_t i=0; i<display.height(); i+=4) {
    display.drawLine(0, 0, display.width()-1, i, WHITE);
  }
  wait_ms(250);
  
  display.clearDisplay();
  for (uint8_t i=0; i<display.width(); i+=4) {
    display.drawLine(0, display.height()-1, i, 0, WHITE);
  }
  for (int8_t i=display.height()-1; i>=0; i-=4) {
    display.drawLine(0, display.height()-1, display.width()-1, i, WHITE);
  }
  wait_ms(250);
  
  display.clearDisplay();
  for (int8_t i=display.width()-1; i>=0; i-=4) {
    display.drawLine(display.width()-1, display.height()-1, i, 0, WHITE);
  }
  for (int8_t i=display.height()-1; i>=0; i-=4) {
    display.drawLine(display.width()-1, display.height()-1, 0, i, WHITE);
  }
  wait_ms(250);

  display.clearDisplay();
  for (uint8_t i=0; i<display.height(); i+=4) {
    display.drawLine(display.width()-1, 0, 0, i, WHITE);
  }
  for (uint8_t i=0; i<display.width(); i+=4) {
    display.drawLine(display.width()-1, 0, i, display.height()-1, WHITE); 
  }
  wait_ms(250);
}

int main()   {                
 // Serial.begin(9600);
  
  display.begin();
  // init done
  
 // wait_ms(2000);
 // display.clearDisplay();   // clears the screen and buffer redundant
/*
  display.drawPixel(10, 10, WHITE);
  display.drawPixel(20, 20, WHITE);
  wait_ms(2000);
 
  display.clearDisplay();

  // draw many lines
  testdrawline();
  delay(2000);
  display.clearDisplay();
  // draw rectangles
  testdrawrect();
  delay(2000);
  display.clearDisplay();

  // draw multiple rectangles
  testfillrect();
  delay(2000);
  display.clearDisplay();

  // draw mulitple circles
  testdrawcircle();
  delay(2000);
  display.clearDisplay();
*/                   

  // draw a circle, 10 pixel radius
  display.fillCircle(20, 20, 20, WHITE);
  wait_ms(2000);

  display.clearDisplay();
  testdrawroundrect();
  wait_ms(2000);
  display.clearDisplay();

  testfillroundrect();
  wait_ms(2000);
  display.clearDisplay();

  testdrawtriangle();
  wait_ms(2000);
  display.clearDisplay();
   
  testfilltriangle();
  wait_ms(2000);
  display.clearDisplay();

  // draw the first ~12 characters in the font
  testdrawchar();
  wait_ms(2000);
  display.clearDisplay();

  // text display tests
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.printf("Hello, world!\n");
  display.setTextColor(BLACK, WHITE); // 'inverted' text
  display.printf("%f",3.141592);
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.printf("0x%8x",0xDEADBEEF);
  wait_ms(2000);

  // miniature bitmap display
  display.clearDisplay();
  display.drawBitmap(30, 16,  logo16_glcd_bmp, 16, 16, 1);

  wait_ms(2000);
  display.clearDisplay();
/*      display.command(GP9002_ADDRINCR);
      display.command(GP9002_ADDRL);
      display.dataWrite(0x00);
      display.command(GP9002_ADDRH);
      display.dataWrite(0x00);
      display.command(GP9002_DATAWRITE);
*/
    int x=0;
    int y;
    int byte;
    for(uint32_t count2=0; count2<128; count2++) {
        y=0;
        for(uint32_t count=count2; count<0x400; count+=128) {
            byte=adabmp[count];
            for(int count3=0; count3<8;count3++) {
                if (byte & 0x01) display.drawPixel(x,y,WHITE);
                byte >>=1;
                y++;
            }
        }
        x++;
    }

}


void loop() {
  
}
