/*#include <avr/pgmspace.h>
#include <util/delay.h>
#include <stdlib.h>*/

#include "Adafruit_GFX.h"
#include "Adafruit_GP9002.h"
#include "glcdfont.c"

extern const unsigned char BitReverseTable256[] = 
{
  0x00, 0x80, 0x40, 0xC0, 0x20, 0xA0, 0x60, 0xE0, 0x10, 0x90, 0x50, 0xD0, 0x30, 0xB0, 0x70, 0xF0, 
  0x08, 0x88, 0x48, 0xC8, 0x28, 0xA8, 0x68, 0xE8, 0x18, 0x98, 0x58, 0xD8, 0x38, 0xB8, 0x78, 0xF8, 
  0x04, 0x84, 0x44, 0xC4, 0x24, 0xA4, 0x64, 0xE4, 0x14, 0x94, 0x54, 0xD4, 0x34, 0xB4, 0x74, 0xF4, 
  0x0C, 0x8C, 0x4C, 0xCC, 0x2C, 0xAC, 0x6C, 0xEC, 0x1C, 0x9C, 0x5C, 0xDC, 0x3C, 0xBC, 0x7C, 0xFC, 
  0x02, 0x82, 0x42, 0xC2, 0x22, 0xA2, 0x62, 0xE2, 0x12, 0x92, 0x52, 0xD2, 0x32, 0xB2, 0x72, 0xF2, 
  0x0A, 0x8A, 0x4A, 0xCA, 0x2A, 0xAA, 0x6A, 0xEA, 0x1A, 0x9A, 0x5A, 0xDA, 0x3A, 0xBA, 0x7A, 0xFA,
  0x06, 0x86, 0x46, 0xC6, 0x26, 0xA6, 0x66, 0xE6, 0x16, 0x96, 0x56, 0xD6, 0x36, 0xB6, 0x76, 0xF6, 
  0x0E, 0x8E, 0x4E, 0xCE, 0x2E, 0xAE, 0x6E, 0xEE, 0x1E, 0x9E, 0x5E, 0xDE, 0x3E, 0xBE, 0x7E, 0xFE,
  0x01, 0x81, 0x41, 0xC1, 0x21, 0xA1, 0x61, 0xE1, 0x11, 0x91, 0x51, 0xD1, 0x31, 0xB1, 0x71, 0xF1,
  0x09, 0x89, 0x49, 0xC9, 0x29, 0xA9, 0x69, 0xE9, 0x19, 0x99, 0x59, 0xD9, 0x39, 0xB9, 0x79, 0xF9, 
  0x05, 0x85, 0x45, 0xC5, 0x25, 0xA5, 0x65, 0xE5, 0x15, 0x95, 0x55, 0xD5, 0x35, 0xB5, 0x75, 0xF5,
  0x0D, 0x8D, 0x4D, 0xCD, 0x2D, 0xAD, 0x6D, 0xED, 0x1D, 0x9D, 0x5D, 0xDD, 0x3D, 0xBD, 0x7D, 0xFD,
  0x03, 0x83, 0x43, 0xC3, 0x23, 0xA3, 0x63, 0xE3, 0x13, 0x93, 0x53, 0xD3, 0x33, 0xB3, 0x73, 0xF3, 
  0x0B, 0x8B, 0x4B, 0xCB, 0x2B, 0xAB, 0x6B, 0xEB, 0x1B, 0x9B, 0x5B, 0xDB, 0x3B, 0xBB, 0x7B, 0xFB,
  0x07, 0x87, 0x47, 0xC7, 0x27, 0xA7, 0x67, 0xE7, 0x17, 0x97, 0x57, 0xD7, 0x37, 0xB7, 0x77, 0xF7, 
  0x0F, 0x8F, 0x4F, 0xCF, 0x2F, 0xAF, 0x6F, 0xEF, 0x1F, 0x9F, 0x5F, 0xDF, 0x3F, 0xBF, 0x7F, 0xFF
};


/*
Adafruit_GP9002::Adafruit_GP9002(int8_t SCLK, int8_t MISO, int8_t MOSI, 
    int8_t CS, int8_t DC) : Adafruit_GFX(128, 64) {
  _sclk = SCLK;
  _miso = MISO;
  _mosi = MOSI;
  _cs = CS;
  _dc = DC;
  hwSPI = false;
}

Adafruit_GP9002::Adafruit_GP9002(int8_t CS, int8_t DC) :
    Adafruit_GFX(128, 64) {
  _sclk = -1;
  _miso = -1;
  _mosi = -1;
  _cs = CS;
  _dc = DC;
  hwSPI = true;
}
*/
Adafruit_GP9002::Adafruit_GP9002(SPI &SPIport, PinName CS, PinName DC): Adafruit_GFX(128, 64), _spi(SPIport), _dc(DC), _cs(CS,1){}  ;


void Adafruit_GP9002::begin(void) {
  // set pin directions
//  pinMode(_dc, OUTPUT);
//  pinMode(_cs, OUTPUT);

/*  if (! hwSPI) {
    pinMode(_mosi, OUTPUT);
    pinMode(_miso, INPUT);
    pinMode(_sclk, OUTPUT);
    
    clkport     = portOutputRegister(digitalPinToPort(_sclk));
    clkpinmask  = digitalPinToBitMask(_sclk);
    mosiport    = portOutputRegister(digitalPinToPort(_mosi));
    mosipinmask = digitalPinToBitMask(_mosi);
    misopin = portInputRegister(digitalPinToPort(_miso));
    misopinmask = digitalPinToBitMask(_miso);
  } else {
  */  
    //SPI.begin();
   // SPI.setClockDivider(SPI_CLOCK_DIV4);
   // SPI.setBitOrder(MSBFIRST);
    //SPI.setDataMode(SPI_MODE0);
     _spi.format(8,3); // I'm sure this is a mode 3 device
     _spi.frequency(2000000); //
 // }
 /*
  csport    = portOutputRegister(digitalPinToPort(_cs));
  cspinmask = digitalPinToBitMask(_cs);
  dcport    = portOutputRegister(digitalPinToPort(_dc));
  dcpinmask = digitalPinToBitMask(_dc);
  */

  command(GP9002_DISPLAY);
  dataWrite(GP9002_DISPLAY_MONOCHROME);
  command(GP9002_LOWERADDR1);
  dataWrite(0x0);
  command(GP9002_HIGHERADDR1);
  dataWrite(0x0);
  command(GP9002_LOWERADDR2);
  dataWrite(0x0);
  command(GP9002_HIGHERADDR2);
  dataWrite(0x4);
  command(GP9002_OR);
  command(GP9002_CLEARSCREEN);
  command(GP9002_DISPLAY1ON);

  // hold the address so we can read and then write
  command(GP9002_ADDRHELD);
}



// updated high speed drawing!
void Adafruit_GP9002::drawFastVLine(int16_t x, int16_t orig_y, int16_t h, uint16_t color) {
  if ((x < 0) || (x >= width()) || (orig_y >= height())) return;
  //if ((orig_y+h) >= height()) 
  //  h = height() - orig_y -1;

  //drawLine(x, orig_y, x, orig_y+h, color); return;

  while (h) {
    if ((h >= 8) && ((orig_y) % 8 == 0)) 
      break;
    drawPixel(x, orig_y, color);
    orig_y++;
    h--;
  }

  if (h >= 8) {
      // calculate addr
      uint16_t addr = 0;
      addr = x*8;
  //    uint16_t y = orig_y+h-8;
       uint16_t y=orig_y;
  //    y = 63 - y;                 //why?
      addr += y/8;

  //    Serial.println(addr, HEX);  ///debug line ?
      command(GP9002_ADDRINCR);
      command(GP9002_ADDRL);
      dataWrite(addr & 0xFF);
      command(GP9002_ADDRH);
      dataWrite(addr >> 8);
      command(GP9002_DATAWRITE);

      while (h >= 8) {
	// draw 8 pixels at once!
	if (color) 
	  dataWrite(0xFF);
	else 
	  dataWrite(0x00);
	h -= 8;
	orig_y += 8;
      }
  }
  while (h+1) {
    drawPixel(x, orig_y-1, color);
    orig_y++;
    h--;
  }

}

// the most basic function, set a single pixel
void Adafruit_GP9002::drawPixel(int16_t x, int16_t y, uint16_t color) {
  if ((x < 0) || (x >= width()) || (y < 0) || (y >= height()))
    return;

  uint8_t p;
  
  // calculate addr
  uint16_t addr = 0;
  addr = x*8;
 // y = 63 - y;                //why
  addr += y/8;

  command(GP9002_ADDRHELD);
  command(GP9002_ADDRL);
  dataWrite(addr & 0xFF);
  command(GP9002_ADDRH);
  dataWrite(addr >> 8);
  command(GP9002_DATAREAD);
  dataRead();
  p = dataRead();

  //Serial.println(p, HEX);

  if (color)
    p |= (1 << (7-(y % 8)));
  else
    p &= ~(1 << (7-(y % 8)));
  command(GP9002_DATAWRITE);
  dataWrite(p);
}

  

void Adafruit_GP9002::invert(bool i) {
  // This is kinda clumsy but it does work
  // fill the opposite screen with all on pixels so we can invert!
  uint16_t addr = 0x400;

  command(GP9002_ADDRINCR);
  command(GP9002_ADDRL);
  dataWrite(addr & 0xFF);
  command(GP9002_ADDRH);
  dataWrite(addr >> 8);
  command(GP9002_DATAWRITE);

  if (i) {
    while (addr < 0x0800) {
      dataWrite(0xFF);
      addr++;
    }
    command(GP9002_XOR);
  } else {
    while (addr < 0x0800) {
      dataWrite(0x00);
      addr++;
    }
    command(GP9002_OR);
  }
  command(GP9002_ADDRHELD);

}
/*
void Adafruit_GP9002::slowSPIwrite(uint8_t d) {
 for (uint8_t i=0; i<8; i++) {
   digitalWrite(_sclk, LOW);
   if (d & _BV(i)) {
     digitalWrite(_mosi, HIGH);
   } else {
     digitalWrite(_mosi, LOW);
   }
   digitalWrite(_sclk, HIGH);
 }
}
*/
/*
inline void Adafruit_GP9002::fastSPIwrite(uint8_t d) {
  if (hwSPI) {
    SPDR = d;
    while(!(SPSR & _BV(SPIF)));
    return;
  }
  for(uint8_t bit = 0x1; bit != 0x00; bit <<= 1) {
    *clkport &= ~clkpinmask;
    if(d & bit) *mosiport |=  mosipinmask;
    else        *mosiport &= ~mosipinmask;
    *clkport |=  clkpinmask;
  }
}
*/
/*
uint8_t Adafruit_GP9002::slowSPIread(void) {
 uint8_t reply = 0;
 for (uint8_t i=0; i<8; i++) {
   digitalWrite(_sclk, LOW);

   digitalWrite(_sclk, HIGH);
   if (digitalRead(_miso)) 
     reply |= _BV(i);
 }
 return reply;
}

inline uint8_t Adafruit_GP9002::fastSPIread(void) {
 uint8_t reply = 0;
 for (uint8_t i=0; i<8; i++) {
   *clkport &= ~clkpinmask;
   
   *clkport |=  clkpinmask;
   if ((*misopin) & misopinmask)
     reply |= _BV(i);
 }
 return reply;
}
*/

void Adafruit_GP9002::command(uint8_t d) { 
/*
  *dcport |= dcpinmask;
  *csport &= ~cspinmask;
  fastSPIwrite(d);
  *csport |= cspinmask;
  delayMicroseconds(1); // should be 400ns actually
*/
_dc=1;
_cs=0;
_spi.write(BitReverseTable256[d]);
_cs=1;
wait_us(1);
}

inline void Adafruit_GP9002::dataWrite(uint8_t d) {
/*
  *dcport &= ~dcpinmask;
  *csport &= ~cspinmask;

  fastSPIwrite(d);

  *csport |= cspinmask;
  delayMicroseconds(1); // should be 600ns actually
*/
_dc=0;
_cs=0;
_spi.write(BitReverseTable256[d]);
_cs=1;
wait_us(1);
}

inline uint8_t Adafruit_GP9002::dataRead() {
  uint8_t r;
/*
  *dcport &= ~dcpinmask;
  *csport &= ~cspinmask;

  r = fastSPIread();

  *csport |= cspinmask;
  delayMicroseconds(1); 
  */

_dc=0;
_cs=0;
r=BitReverseTable256[_spi.write(0)&0xFF];
_cs=1;
wait_us(1);


 return r;
}

void Adafruit_GP9002::setBrightness(uint8_t val) {
  
}

// clear everything
void Adafruit_GP9002::clearDisplay(void) {
  command(GP9002_CLEARSCREEN);

  wait_ms(1);
}

void Adafruit_GP9002::displayOff(void) {
  command(GP9002_DISPLAYSOFF); 
}
void Adafruit_GP9002::displayOn(void) {
   command(GP9002_DISPLAY1ON);
}


