#include "mbed.h"
#include "EthernetInterface.h"

#include <stdarg.h>
#include <stdio.h>

#include "C12832_lcd.h"

C12832_LCD lcd;

extern "C" {

void user_printf( const char* buffer )
{
    lcd.cls();
    lcd.locate( 0, 0 );
    lcd.printf( buffer );
    // wait( 1.0 );    
}

void mbed_printf( const char* fmt, ...  )
{
    char buffer[ 64 ];
    
    va_list ap;
    va_start( ap, fmt );
    vsnprintf( buffer, 64, fmt, ap );
    va_end( ap );
    
    user_printf( buffer );
}

}

#define ADDRESS "api.cosm.com"
#define PORT 80
#define API_KEY "youre_api_key"
#define FEED_ID "youre_feed_id"

#define MSG "PUT /v2/feeds/" FEED_ID ".csv HTTP/1.1\r\n"\
            "Host: api.xively.com\r\n"\
            "User-Agent: mbed_test/0.1.x\r\n"\
            "Accept: */*\r\n"\
            "X-ApiKey: " API_KEY "\r\n"\
            "Content-Type: text/plain\r\n"\
            "Content-Length: 33\r\n\r\n"\
            "0001,test1\n"\
            "0002,test2\n"\
            "0003,test3\n\0"
 

int main() {
    EthernetInterface eth;
    
    int s = eth.init(); //Use DHCP
    
    size_t msg_len = strlen( MSG );
    
    if( s != NULL )
    {
        mbed_printf( "Could not initialise. Will halt!\n" );        
        exit( 0 );
    }    
        
    s = eth.connect();
    
    if( s != NULL )
    {
        mbed_printf( "Could not connect. Will halt!\n" );
        exit( 0 );
    }
    else 
    {
        mbed_printf( "IP: %s\n", eth.getIPAddress() );    
    }

    
    TCPSocketConnection connection;
    #define RECV_BUFFER_SIZE 512
    char buffer[ RECV_BUFFER_SIZE ];
    
    while( 1 )
    {
        if( connection.connect( ADDRESS, PORT ) == -1 )
        {
            mbed_printf( "Error during connection attempt\n" );
            wait( 1.0 );
            continue;
        }
        
        if( connection.send( MSG, msg_len ) == -1 )
        {
            mbed_printf( "Error during send attempt\n" );
            wait( 1.0 );
            goto close;
        }
         
        memset( buffer, 0, RECV_BUFFER_SIZE ); 
        
        if( connection.receive( buffer, RECV_BUFFER_SIZE ) == -1 )
        {
            mbed_printf( "Error during receive attempt\n" );
            wait( 1.0 );
        }
close:        
        connection.close();
    }
}
