#include "mbed.h"
#include "BME280.h"
#include "OPT3001.h"

DigitalOut led(LED1);
BME280 sensor_bme(D14, D15);
OPT3001 sensor_opt(D14, D15);
EventQueue eventQueue(/* event count */ 50 * EVENTS_EVENT_SIZE);
Serial pc(SERIAL_TX, SERIAL_RX);
LowPowerTicker lpTicker;

void printTemperature(void)
{
    pc.printf("%2.2f degC, %04.2f hPa, %2.2f %%\r\n", sensor_bme.getTemperature(), sensor_bme.getPressure(), sensor_bme.getHumidity());
    pc.printf("%ld lux\r\n", sensor_opt.readSensor());        
    led = !led; // Toggle LED
}

void tickerIRQ (void)
{
    eventQueue.call(printTemperature);
}

int main()
{
    pc.baud(115200);
    
    lpTicker.attach(tickerIRQ, 1); // every second
    
    while(1)
    {
        eventQueue.dispatch(0);
        sleep();
    }
}