#include "mbed.h"

DigitalOut ledRed(LED_RED);
DigitalOut ledGreen(LED_GREEN);
DigitalOut ledBlue(LED_BLUE);

int flashPattern = 0;

const unsigned char I2C_ADDR_PCF8591T  = 0x9E;
const unsigned char I2C_ADDR_PCA9672PW = 0x46;

const unsigned char LED_ON  = 0;
const unsigned char LED_OFF = 1;
bool keyPressed;
char response[1];

I2C m_i2c(P0_10, P0_11);

unsigned char i2c_wait(int ms)
{
    for(int n=0; n<ms; n+=50) {
        //read PCA9672PW
        if (m_i2c.read(I2C_ADDR_PCA9672PW, response, 1) == 0) {
            //check if push-button pressed (bit #7 = 0)
            if ((keyPressed == false) && ((response[0] & 0x80) == 0))
                return 1;
        } else {
            //error reading from I2C device
            while(1) {
                for(int i=0; i<10; i++) {
                    ledBlue = LED_ON;
                    wait(0.05);
                    ledBlue = LED_OFF;
                    wait(0.05);
                }
                wait(1.0);
            }
        }
        wait(0.05);
    }
    return 0;
}

int main()
{
    //init RGB-LED to be off
    ledRed   = LED_OFF;
    ledGreen = LED_OFF;
    ledBlue  = LED_OFF;

    //test i2C connection with PCF8591T  (1.0.0.1.1.1.1.rw)
    const char command1[] = {0x00};
    if (m_i2c.write(I2C_ADDR_PCF8591T, command1, 1) != 0) {
        while(1) {
            for(int i=0; i<10; i++) {
                ledRed = LED_ON;
                wait(0.05);
                ledRed = LED_OFF;
                wait(0.05);
            }
            wait(1.0);
        }
    }

    //test i2C connection with PCA9672PW (0.1.0.0.0.1.1.rw)
    const char command2[] = {0xff};
    if (m_i2c.write(I2C_ADDR_PCA9672PW, command2, 1) != 0) {
        while(1) {
            for(int i=0; i<10; i++) {
                ledBlue = LED_ON;
                wait(0.05);
                ledBlue = LED_OFF;
                wait(0.05);
            }
            wait(1.0);
        }
    }

    //startup flash behaviour
    for(int i=0; i<10; i++) {
        ledGreen = LED_ON;
        wait(0.05);
        ledGreen = LED_OFF;
        wait(0.05);
    }
    wait(1.0);

    //enter forever loop, change RGB flash patterns with user push-button
    keyPressed = false;
    i2c_wait(1);
    while(1) {
        //read user push-button
#if 1
        i2c_wait(1);
        //check if push-button pressed (bit #7 = 0)
        if ((keyPressed == false) && ((response[0] & 0x80) == 0)) {
            keyPressed = true;
            flashPattern++;
        }

        //check if push-button released (bit #7 = 1)
        else if ((keyPressed == true) && ((response[0] & 0x80) != 0))
            keyPressed = false;
#else
        if (m_i2c.read(I2C_ADDR_PCA9672PW, response, 1) == 0) {
            //check if push-button pressed (bit #7 = 0)
            if ((keyPressed == false) && ((response[0] & 0x80) == 0)) {
                keyPressed = true;
                flashPattern++;
                ledRed = LED_OFF;
                ledGreen = LED_OFF;
                ledBlue = LED_OFF;
            }

            //check if push-button released (bit #7 = 1)
            else if ((keyPressed == true) && ((response[0] & 0x80) != 0))
                keyPressed = false;
        }
        //error reading from I2C device
        else {
            while(1) {
                for(int i=0; i<10; i++) {
                    ledBlue = LED_ON;
                    wait(0.05);
                    ledBlue = LED_OFF;
                    wait(0.05);
                }
                wait(1.0);
            }
        }
#endif
        //flash RGB-LED according to pattern
        switch(flashPattern) {
            case 0:
                ledRed = LED_ON;
                if (i2c_wait(80) != 0) break;
                ledRed = LED_OFF;
                if (i2c_wait(500) != 0) break;

                ledGreen = LED_ON;
                if (i2c_wait(15) != 0) break;
                ledGreen = LED_OFF;
                if (i2c_wait(550) != 0) break;

                ledBlue = LED_ON;
                if (i2c_wait(80) != 0) break;
                ledBlue = LED_OFF;
                if (i2c_wait(500) != 0) break;
                break;
            case 1:
                for(float a=0; a<0.01; a+=0.0004) {
                    ledGreen = LED_ON;
                    wait(a/2);
                    ledGreen = LED_OFF;
                    wait(0.01-a);
                }
                ledGreen = LED_ON;
                if (i2c_wait(1) != 0) break;
                for(float a=0.01; a>0.0; a-=0.0002) {
                    ledGreen = LED_ON;
                    wait(a/2);
                    ledGreen = LED_OFF;
                    wait(0.01-a);
                }
                if (i2c_wait(400) != 0) break;
                break;
            case 2:
                ledRed = LED_ON;
                if (i2c_wait(150) != 0) break;
                ledRed = LED_OFF;
                if (i2c_wait(150) != 0) break;

                ledGreen = LED_ON;
                if (i2c_wait(100) != 0) break;
                ledGreen = LED_OFF;

                ledBlue = LED_ON;
                if (i2c_wait(150) != 0) break;
                ledBlue = LED_OFF;
                break;
            case 3:
                ledRed = LED_ON;
                ledGreen = LED_ON;
                ledBlue = LED_ON;
                if (i2c_wait(10) != 0) break;

                ledGreen = LED_OFF;
                ledBlue = LED_OFF;
                ledRed = LED_OFF;
                if (i2c_wait(500) != 0) break;
                break;
            case 4:
                for(float a=0; a<0.01; a+=0.0008) {
                    ledRed = LED_ON;
                    wait(a);
                    ledRed = LED_OFF;
                    wait(0.01-a);
                }
                ledRed = LED_ON;
                if (i2c_wait(1) != 0) break;
                for(float a=0; a<0.01; a+=0.0008) {
                    ledBlue = LED_ON;
                    wait(a);
                    ledBlue = LED_OFF;
                    wait(0.01-a);
                }
                ledBlue = LED_ON;
                if (i2c_wait(1) != 0) break;
                for(float a=0.01; a>0.0; a-=0.0008) {
                    ledRed = LED_ON;
                    wait(a);
                    ledRed = LED_OFF;
                    wait(0.01-a);
                }
                if (i2c_wait(1) != 0) break;
                for(float a=0.01; a>0.0; a-=0.0008) {
                    ledBlue = LED_ON;
                    wait(a);
                    ledBlue = LED_OFF;
                    wait(0.01-a);
                }
                if (i2c_wait(200) != 0) break;
                break;
            default:
                flashPattern = 0;
                break;
        }
    }
}

#if 0
//https://github.com/mbedmicro/mbed/tree/master/libraries/mbed/vendor/NXP/capi/LPC812
P0_0 = 0,
P0_1 = 1,
P0_2 = 2,
P0_3 = 3,
P0_4 = 4,
P0_5 = 5,
P0_6 = 6,
P0_7 = 7,
P0_8 = 8,
P0_9 = 9,
P0_10 = 10, //SDA
P0_11 = 11, //SCL
P0_12 = 12,
P0_13 = 13,
P0_14 = 14,
P0_15 = 15,
P0_16 = 16,
P0_17 = 17,

D0 = P0_0,
D1 = P0_4,
D2 = P0_6,
D3 = P0_8,
D4 = P0_9,

D7 = P0_7,
D8 = P0_17,
D9 = P0_16,
D10 = P0_13,
D11 = P0_14,
D12 = P0_15,
D13 = P0_12,

A4 = P0_10,
A5 = P0_11,

// LPC800-MAX board
LED_RED = P0_7,
LED_GREEN = P0_17,
LED_BLUE = P0_16,

// mbed original LED naming
LED1 = LED_BLUE,
LED2 = LED_GREEN,
LED3 = LED_RED,
LED4 = LED_RED,

// Serial to USB pins
USBTX = P0_6,
USBRX = P0_1,
#endif
