#ifndef FATFS_IJFW_CONFIGURABLE_H
#define FATFS_IJFW_CONFIGURABLE_H

#include "mbed.h"
#include "FatfsIJFW.h"

const int CONFIG_ITEM_NUM = 3;
const int ITEM_NAME_LENGTH = 32;
const int ITEM_VAL_LENGTH = 8;

typedef struct {
    char itemName[ITEM_NAME_LENGTH+1];
    char itemValue[ITEM_VAL_LENGTH+1];
} ConfigItem;

class FatfsIjfwConfigurable : public FatfsIJFW {
public:
    FatfsIjfwConfigurable(SPI* _spi, DigitalOut* _cs);

    int setConfigValue(const char* itemName, const char* value);
    int getConfigValue(const char* itemName, char* buf);
    int readConfigFile(const char* configFiie);

    int chdir(const char* dir);
    int openBas(const char* name, const FileMode mode);
    int checkFirmFile(const char* binfile);
    int deleteFirmFile(const char* binfile);

protected:
    void initConfigItem();
    int readLine(char* buf, int length);

    ConfigItem configitem[CONFIG_ITEM_NUM];

};

#endif
