#ifndef UART_ISP_BASE_H
#define UART_ISP_BASE_H


class UartIspBase {
public:

    UartIspBase();
    virtual ~UartIspBase();

    virtual void writeSerial(const char val) = 0;
    virtual char readSerial() = 0;
    virtual int readable() = 0;
    virtual void sleep(int msec) = 0;
    
protected:

    void disableEchoBack();
    int openIsp(int mcufreq);
    int unlockFlash();
    int eraseFlash(int startSector, int endSector);
    int writeToRam(char buffer[], unsigned int ramAddress, int length);
    int prepareFlash(int startSector, int endSector);
    int copyToFlash(unsigned int flashAddress, unsigned int ramAddress, int length);

private:

    char uuCharTable[64];
    int echoBack;

    char getUuString(int i);
    void writeString(const char val);
    void writeString(const char* str);
    int isRecieveStringMatch(const char* checkString);

};
#endif
