#ifndef UART_ISP_H
#define UART_ISP_H

#include "mbed.h"
#include "UartIspBase.h"
#include "FatfsIjfwConfigurable.h"

class UartIsp : public UartIspBase {
public:
    enum ISP_RESULT {
        NOERROR,
        ERR_FILE_OPEN,
        ERR_SYNC_MCU,
        ERR_UNLOCK_FLASH,
        ERR_FILE_READ,
        ERR_WRITE_TO_RAM,
        ERR_COPY_TO_FLASH,
    };

    UartIsp(RawSerial* _serial, FatfsIjfwConfigurable* _fs);
    virtual ~UartIsp();

    virtual void writeSerial(const char val);
    virtual char readSerial();
    virtual int readable();
    virtual void sleep(int msec);

    ISP_RESULT runUartIsp(const char* filename);
    
protected:
    
    RawSerial* serial;
    FatfsIjfwConfigurable* fs;
    char* buffer;

};

#endif
