#ifndef I2C2MEM_H
#define I2C2MEM_H

#include "mbed.h"
#include "UartIspBase.h"
#include "I2CSlave2.h"
#include "FatfsIjfwConfigurable.h"

class I2c2mem {
public:
    I2c2mem(I2CSlave2* _i2cs, FatfsIjfwConfigurable* _fs, DigitalOut* _ledcard);
    ~I2c2mem();
   
    int writeProgram(int flag);
    int readProgram();
    int writeData();
    int readData();
    int writeDataContinuous();
    int reset();
    
protected:
    I2CSlave2* i2cs;
    FatfsIjfwConfigurable* fs;
    DigitalOut* ledcard;

    int address;
    int address_old;
    int count;
    char filename[16];
    char* buffer;
    
    int dataBytesCount;
    int dataFileNum;

};

#endif
