#include "I2CSlave2.h"

I2CSlave2::I2CSlave2(PinName sda, PinName scl) : I2CSlave(sda, scl) {
}

void I2CSlave2::address(int address, int mask) {
    int addr = (address & 0xFF) | 1;
    i2c_slave_address(&_i2c, 0, addr, 0);
    LPC_I2C->MASK0 = mask;
}

int I2CSlave2::read(char *data, int length) {
    return i2c_slave_read(&_i2c, data, length);
}

int I2CSlave2::read() {
    return i2c_byte_read(&_i2c, 0);
}

int I2CSlave2::write(const char *data, int length) {
    return i2c_slave_write(&_i2c, data, length);
}

int I2CSlave2::write(int data) {
    return i2c_byte_write(&_i2c, data);
}

// This function must be called immediately after receive().
int I2CSlave2::addressFromMaster() {
    return LPC_I2C->DAT;
}
