#include "mbed.h"
#include "ff.h"
#include "FatfsIjfwConfigurable.h"

FatfsIjfwConfigurable::FatfsIjfwConfigurable(SPI* _spi, DigitalOut* _cs) : FatfsIJFW(_spi, _cs) {
    initConfigItem();
}


void FatfsIjfwConfigurable::initConfigItem() {
    strncpy(configitem[0].itemName, "FirmUpdate", ITEM_NAME_LENGTH);
    strncpy(configitem[0].itemValue, "1", ITEM_VAL_LENGTH);
    strncpy(configitem[1].itemName, "FirmFileDelete", ITEM_NAME_LENGTH);
    strncpy(configitem[1].itemValue, "1", ITEM_VAL_LENGTH);
    strncpy(configitem[2].itemName, "BasDirectory", ITEM_NAME_LENGTH);
    strncpy(configitem[2].itemValue, "", ITEM_VAL_LENGTH);
}


int FatfsIjfwConfigurable::setConfigValue(const char* setName, const char* setValue) {
    for (int i = 0; i < CONFIG_ITEM_NUM; i++) {
        if (strncmp(configitem[i].itemName, setName, ITEM_NAME_LENGTH) == 0) {
            strncpy(configitem[i].itemValue, setValue, ITEM_VAL_LENGTH);
            configitem[i].itemValue[ITEM_VAL_LENGTH] = '\0';    // if setValue length is equal to ITEM_VAL_LENGTH
            return 1;
        }
    }
    
    return 0;
}


int FatfsIjfwConfigurable::getConfigValue(const char* setName, char* buf) {
    for (int i = 0; i < CONFIG_ITEM_NUM; i++) {
        if (strncmp(configitem[i].itemName, setName, ITEM_NAME_LENGTH) == 0) {
            strncpy(buf, configitem[i].itemValue, ITEM_VAL_LENGTH);
            buf[ITEM_VAL_LENGTH] = '\0';    // if itemValue length is equal to ITEM_VAL_LENGTH
            return 1;
        }
    }

    return 0;
}


int FatfsIjfwConfigurable::readLine(char* buf, int length) {
    if (f_gets(buf, (UINT)length, &file) != NULL) {
        return 1;
    }
    return 0;
}


int FatfsIjfwConfigurable::readConfigFile(const char* configFiie) {
    mount();
    if (open(configFiie, MODE_RO) != FR_OK) {
        return -1;
    }

    int retval = 0;
    char buf[42], tempbuf[64];

    while(readLine(tempbuf, sizeof(tempbuf))) {
        // delete space and tab
        for (int i = 0, j = 0; i < sizeof(tempbuf); i++) {
            if (tempbuf[i] != ' ' && tempbuf[i] != '\t') {
                if (j < sizeof(buf)) {
                    buf[j] = tempbuf[i];
                    j++;
                }
            }
            if (tempbuf[i] == 0x0d || tempbuf[i] == 0x0a) {
                buf[j] = '\0';
                break;
            }
        }

        // comment
        if (buf[0] == '#') {
            continue;
        }

        // position of separator
        int i, pos_sep;
        for (i = 0; i < sizeof(buf); i++) {
            if (buf[i] == '=') {
                pos_sep = i;
                buf[i] = '\0';
            } else if (buf[i] == '\0') {
                break;
            }
        }

        // check length
        if (pos_sep > ITEM_NAME_LENGTH - 1) {
            retval = -2;
        }
        if ( (i-1) - (pos_sep+1) > ITEM_VAL_LENGTH - 1) {
            retval = -3;
        }

        // set value
        setConfigValue(buf, &buf[pos_sep+1]);
    }

    close();
    return retval;
}


int FatfsIjfwConfigurable::openBas(const char* name, const FileMode mode) {
    char buf[ITEM_VAL_LENGTH+1];
    getConfigValue("BasDirectory", buf);

    if (strlen(buf) > 0) {
        mkdir(buf);
        chdir("/");
        int res = chdir(buf);
        if (res != FR_OK) {
            return res;
        }
    }

    return open(name, mode);
}


int FatfsIjfwConfigurable::chdir(const char* path) {
    FRESULT res = f_chdir(path);
    return (int)res;
}


int FatfsIjfwConfigurable::checkFirmFile(const char* binfile) {
    char buf[ITEM_VAL_LENGTH+1];
    getConfigValue("FirmUpdate", buf);

    if (strncmp(buf, "0", 1) == 0) {
        return 0;
    }

    mount();
    if (open(binfile, MODE_RO) == FR_OK) {
        close();
        return 1;
    }

    return 0;
}


int FatfsIjfwConfigurable::deleteFirmFile(const char* binfile) {
    char buf[ITEM_VAL_LENGTH+1];
    getConfigValue("FirmFileDelete", buf);

    if (strncmp(buf, "1", 1) == 0) {
        remove(binfile);
        return 1;
    }

    return 0;
}
