#ifndef FATFS_IJFW_H
#define FATFS_IJFW_H

#include "mbed.h"
#include "diskio.h"
#include "ff.h"

enum FileMode {
	MODE_WR,
	MODE_RO,
	MODE_APPEND,
	MODE_OVERWRITE,
};

class FatfsIJFW {
public:

    FatfsIJFW(SPI* _spi, DigitalOut* _cs);

	int mount();
	int open(const char* name, const FileMode mode);
	int close();
	int remove(const char* filename);
	int mkdir(const char* name);
	int read(char* buf, const int length);
	int write(const char* buf, const int length);
	int lseek(int pos);
	int filesize();
	void timerproc();

	DSTATUS disk_initialize(BYTE drv);
	DSTATUS disk_status(BYTE drv);
	DRESULT disk_read(BYTE drv, BYTE* buff, DWORD sector, UINT count);
	DRESULT disk_write(BYTE drv, const BYTE* buff, DWORD sector, UINT count);
	DRESULT disk_ioctl(BYTE drv, BYTE cmd, void* buff);

protected:

	SPI* spi;
	DigitalOut* cs;
    FATFS fs;
    FIL file;
    
    int timerCount;
    DSTATUS Stat;

	int select(void);
	void deselect(void);
	int waitReady(int wait);
	char sendCommand(BYTE cmd, DWORD arg);
	int rcvDataBlock(BYTE *buff, UINT btr);
	int sendDataBlock(const BYTE *buff, BYTE token);

};

#endif
