#include "mbed.h"

//#define I2C_SLAVE_MOD

#ifdef I2C_SLAVE_MOD
#include "I2CSlave_mod_NXP.h"
I2CSlave_mod slave(dp5, dp27);          // sda, scl
#else
I2CSlave slave(dp5, dp27);              // sda, scl
#endif

Serial serial(dp16, dp15);              // tx, rx
DigitalOut led(LED1);                  // indicator

int main() {
    led = 0;
    serial.baud(115200);

    char buf[10];
    slave.address(0x80);

    while(1) {
        int i = slave.receive();
        switch (i) {
            case I2CSlave::ReadAddressed:
                //slave.write(msg, strlen(msg) + 1); // Includes null char
                led = 0;
                break;
            case I2CSlave::WriteGeneral:
                //slave.read(buf, 10);
                //printf("Read G: %s\n", buf);
                led = 0;
                break;
            case I2CSlave::WriteAddressed:
                if (slave.read(buf, 10) == 0) {
                    // success
                    serial.printf("Read success. DATA: %s\n", buf);
                    led = 1;
                } else {
                    // failure
                    serial.printf("Read failure. DATA: %s\n", buf);
                    led = 0;
                }
                break;
        }

        for(int i = 0; i < 10; i++) buf[i] = 0;    // Clear buffer
    }
}
