#include "I2CSlave_mod_NXP.h"

#define I2C_CONSET(x)       (x->i2c->CONSET)
#define I2C_CONCLR(x)       (x->i2c->CONCLR)
#define I2C_DAT(x)          (x->i2c->DAT)
#define I2C_STAT(x)         (x->i2c->STAT)

static inline void i2c_conclr(i2c_t *obj, int start, int stop, int interrupt, int acknowledge) {
    I2C_CONCLR(obj) = (start << 5)
                    | (stop << 4)
                    | (interrupt << 3)
                    | (acknowledge << 2);
}

// Clear the Serial Interrupt (SI)
static inline void i2c_clear_SI(i2c_t *obj) {
    i2c_conclr(obj, 0, 0, 1, 0);
}

static inline int i2c_status(i2c_t *obj) {
    return I2C_STAT(obj);
}

// Wait until the Serial Interrupt (SI) is set
static int i2c_wait_SI(i2c_t *obj) {
    int timeout = 0;
    while (!(I2C_CONSET(obj) & (1 << 3))) {
        timeout++;
        if (timeout > 100000) return -1;
    }
    return 0;
}


I2CSlave_mod::I2CSlave_mod(PinName sda, PinName scl) : I2CSlave(sda, scl) {
}


int I2CSlave_mod::read(char *data, int length) {
    return i2c_slave_read_mod(&_i2c, data, length) != length;
}


int I2CSlave_mod::i2c_slave_read_mod(i2c_t *obj, char *data, int length) {
    int count = 0;
    int status;
    
    do {
        if((status == 0x80) || (status == 0x90)) {
            data[count] = I2C_DAT(obj) & 0xFF;
            count++;
        }
        i2c_clear_SI(obj);
        i2c_wait_SI(obj);
        status = i2c_status(obj);
    } while (((status == 0x80) || (status == 0x90) ||
            (status == 0x060) || (status == 0x70)) && (count < length));
    
    if(status != 0xA0) {
        i2c_stop(obj);
    }
    
    i2c_clear_SI(obj);
    
    return count;
}
