#include "mbed.h"
#include "GSwifi.h"

#define SAMPLES 1250
#define INTERVAL 60
#define CT (3000 / 330 / 0.98)

#define SECURE GSwifi::SEC_WPA_PSK
#define SSID "SSID"
#define PASS "passkey"

#define FEED_HOST "api.xively.com"
#define FEED_ID "000000"
#define API_KEY "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

//GSwifi gs(p13, p14, NC, NC, p20); // LPC1768, LPC11U24
GSwifi gs(PTD3, PTD2, NC, NC, PTA13); // FRDM KL25Z
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2), led3(LED3);
AnalogIn ad0(PTB0), ad1(PTB3), ad2(PTC2);

float ref;
volatile int count = 0;
volatile double sum1 = 0, sum2 = 0;
volatile int busy = 1, status = 1, timeout = 0;


extern "C" void HardFault_Handler() {
    register unsigned int _msp __asm("msp");
    printf("Hard Fault! address: %08x\r\n", *((unsigned int *)(_msp + 24)));
    exit(-1);
}  

int xively (char *data) {
  int i;
  int cid;
  char buf[128];
  char ip[17];

  if (gs.getHostByName(FEED_HOST, ip)) return -1;
  cid = gs.open(GSwifi::PROTO_TCP, ip, 80);
  if (cid < 0) return -1;
  
  sprintf(buf, "PUT /v2/feeds/" FEED_ID ".csv HTTP/1.1\r\n");
  gs.send(cid, buf, strlen(buf));
  sprintf(buf, "Host: " FEED_HOST "\r\n");
  gs.send(cid, buf, strlen(buf));
  sprintf(buf, "Connection: close\r\n");
  gs.send(cid, buf, strlen(buf));
  sprintf(buf, "X-ApiKey: " API_KEY "\r\n");
  gs.send(cid, buf, strlen(buf));
  sprintf(buf, "Content-Type: text/csv\r\n");
  gs.send(cid, buf, strlen(buf));
  sprintf(buf, "Content-Length: %d\r\n", strlen(data));
  gs.send(cid, buf, strlen(buf));
  gs.send(cid, "\r\n", 2);
  gs.send(cid, data, strlen(data));

  for (i = 0; i < 10; i ++) {
    gs.poll();
    if (! gs.isConnected(cid)) break;
    wait_ms(100);
  }
  gs.close(cid);
  return 0;
}

void isr_ticker () {
    static int w = 0, x = 0;
    double a1, a2;

    w ++;
    if (w >= (SAMPLES / 10)) {
        if (status) {
            led1 = x < 5 ? 0 : 1;
        } else {
            led1 = 1;
        }

        w = 0;
        x ++;
        if (x >= 10) {
            x = 0;
            led1 = (timeout & 1) ? 0 : 1;
            if (timeout) timeout --;
        }
    }

    if (busy) return;
    a1 = ad1 - ref;
    a2 = ad2 - ref;
    sum1 += (a1 * a1);
    sum2 += (a2 * a2);
    count ++;
}

int main () {
    char ipaddr[17], netmask[17], gateway[17];
    Ticker ticker;
    int num = 0;
    char buf[128];

    led1 = 0;
    led2 = led3 = 1;
    pc.baud(115200);
    pc.printf("Xively\r\n");
    ticker.attach(isr_ticker, 1.0f / SAMPLES);

    pc.printf("connect\r\n");
    NVIC_SetPriority(UART2_IRQn, 1);
    gs.setAddress("wattmeter");
    gs.setSsid(SECURE, SSID, PASS);
    if (gs.join()) {
        return -1;
    }
    gs.getAddress(ipaddr, netmask, gateway);
    pc.printf("ip %s\r\n", ipaddr);

    ref = ad0;
    status = 0;
    busy = 0;
    timeout = 2;

    for (;;) {
        gs.poll();

        if (timeout == 0) {
            double a1, a2;
            double f1, f2;
            int c;

            busy = 1;
            a1 = sum1;
            a2 = sum2;
            c = count;
            count = 0;
            sum1 = 0;
            sum2 = 0;
            timeout = INTERVAL;
            num ++;
            ref = ad0;
            if (c) {
                f1 = sqrt(a1 / c);
                f2 = sqrt(a2 / c);
                if (f1 < 0.001 && f1 > -0.001) {
                    f1 = 0;
                } else {
                    f1 = f1 * 3.3 * CT;
                }
                if (f2 < 0.001 && f2 > -0.001) {
                    f2 = 0;
                } else {
                    f2 = f2 * 3.3 * CT;
                }

                led2 = 0;
                led3 = 1;
                sprintf(buf, "Total,%0.0f\r\nL1,%0.2f\r\nL2,%0.2f\r\nUptime,%d\r\n", (f1 + f2) * 100, f1, f2, num);
                if (xively(buf)) led3 = 0;
                pc.printf("L1=%0.3f, L2=%0.3f, Uptime=%d, ref=%0.2f\r\n", f1, f2, num, ref);
                led2 = 1;
            }
            busy = 0;
        }
    }
}
