/*
 * mbed library for ulaw
 * Copyright (c) 2010 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

#include "ulaw.h"

// unsigned 16(14)bit to signed 8bit
char pcm2ulaw (int dat) {
    int num, ret, seg;

    dat = dat - 0x7fff;
    if (dat & 0x8000) {
        num = - dat;
    } else {
        num = dat;
    }
    num = num >> 2;
    
    num = num + 0x21;
    if (num >= 0x2000) num = 0x1fff;
    for (seg = 7; seg >= 0; seg --) {
        if (num & 0x1000) break;
        num = num << 1;
    }
    ret = ((num >> 8) & 0x0f) | (seg << 4);

    if (dat & 0x8000) ret = ret | 0x80;
    return ~ret;
}


// signed 8bit to unsigned 16(14)bit
int ulaw2pcm (char dat) {
    int num, ret, seg;

    num = ~dat;

    seg = (num >> 4) & 0x07;
    ret = (0x21 | ((num & 0x0f) << 1)) << seg;
    ret = ret - 0x21;

    ret = ret << 2;
    if (dat & 0x80) ret = - ret;
    ret = ret + 0x8000;
    return ret;
}
