#include "mbed.h"
#include "EthernetNetIf.h"
#include "logger.h"

DigitalOut myled(LED1);
EthernetNetIf eth;
logger *syslog;

int main() {
    EthernetErr r;
    int i;
    char buf[100];

    r = eth.setup();
    if (r) {
        printf("Error %d in setup.\n", r);
        return -1;
    }

    syslog = new logger(&eth, "192.168.1.8", "mbed");

    i = 0;
    while(1) {
        Net::poll();
        sprintf(buf, "message %d", i++);
        syslog->send("test:", buf);
        wait(5);
    }
}
