#include "mbed.h"
#include "SDHCFileSystem.h"

#define SIZE 1024 // KB

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
SDFileSystem sd(p5, p6, p7, p8, "sd");

float wtest (int b, int d) {
    int i;
    int s = b / d;
    char buf[d];
    FILE *fp;
    Timer t;

    fp = fopen("/sd/sdhc_test.dat", "w");
    if (!fp) return 0;
    myled = 1;
    t.reset();
    t.start();
    for (i = 0; i < s; i ++) {
        fwrite(buf, sizeof(unsigned char), d, fp);
    }
    fclose(fp);
    t.stop();
    myled = 0;
    return t.read();
}

float rtest (int b, int d) {
    int i;
    int s = b / d;
    char buf[d];
    FILE *fp;
    Timer t;

    fp = fopen("/sd/sdhc_test.dat", "r");
    if (!fp) return 0;
    myled = 1;
    t.reset();
    t.start();
    for (i = 0; i < s; i ++) {
        fread(buf, sizeof(unsigned char), d, fp);
    }
    fclose(fp);
    t.stop();
    myled = 0;
    return t.read();
}

int main() {

    pc.baud(115200);
    pc.printf("start\r\n");

    if (sd.disk_initialize()) return -1;

    pc.printf("write   1: %f KB/sec\r\n", (double)SIZE / wtest(SIZE * 1024, 1));
    pc.printf("read    1: %f KB/sec\r\n", (double)SIZE / rtest(SIZE * 1024, 1));
    pc.printf("write 100: %f KB/sec\r\n", (double)SIZE / wtest(SIZE * 1024, 100));
    pc.printf("read  100: %f KB/sec\r\n", (double)SIZE / rtest(SIZE * 1024, 100));
    pc.printf("write 10k: %f KB/sec\r\n", (double)SIZE / wtest(SIZE * 1024, 10000));
    pc.printf("read  10k: %f KB/sec\r\n", (double)SIZE / rtest(SIZE * 1024, 10000));

    return 0;
}
