#include "mbed.h"
#include "mbed_rpc.h"

Serial pc(USBTX, USBRX);

int main() {
    char buf[256], outbuf[256];

    // setup the classes that can be created dynamically
//    RPC::add_rpc_class<RpcAnalogIn>();
//    RPC::add_rpc_class<RpcAnalogOut>();
    RPC::add_rpc_class<RpcDigitalIn>();
    RPC::add_rpc_class<RpcDigitalOut>();
    RPC::add_rpc_class<RpcDigitalInOut>();
    RPC::add_rpc_class<RpcPwmOut>();
    RPC::add_rpc_class<RpcTimer>();
    RPC::add_rpc_class<RpcSPI>();
    RPC::add_rpc_class<RpcSerial>();

    // receive commands, and send back the responses
    while(1) {
        pc.gets(buf, 256);
        RPC::call(buf, outbuf); 
        pc.printf("%s\r\n", outbuf);
    }
}
