#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"
#include "CometClient.h"
#include <new>

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
EthernetNetIf eth;

void HardFault_Handler() {
    printf("Hard Fault!\n");
    exit(-1);
}

void no_memory () {
    printf("panic: can't allocate to memory!\r\n");
    exit(-1);
}

int main () {
    EthernetErr ethErr;
    Host host;
    int i, r;
    char buf[100];

    pc.baud(115200);
    myled = 1;

    set_new_handler(no_memory); // new handler function

    ethErr = eth.setup();
    if(ethErr) {
        return -1;
    }

    host.setIp(IpAddr(49, 212, 96, 62));
    r = openComet(&host, "/stream.php", NULL, "data=hello");
    printf("status %d\r\n", r);

    while (1) {
        myled = 1;
        pollComet();
        myled = 0;
        
        i = recvComet(buf, 1000);
        if (i) {
            buf[i] = 0;
            printf("RECV: %s\r\n", buf);
        }
        
        if (pc.readable()) {
            strcpy(buf, "data= ");
            buf[5] = pc.getc();
            printf("SEND: %s\r\n", buf);
            sendComet(buf);
        }
    }

    return 0;
}
