#include "mbed.h"
#include "player.h"

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

Ticker ticker;

extern int dac_step;


extern "C" void HardFault_Handler() {
    printf("Hard Fault!\r\n");
    exit(-1);
}  

void isr_ticker ()
{
    static int w = 0;

    // LED off
    w ++;
    if (w >= 10) {
        led4 = 0;
        w = 0;
    }
}

void poll () {
    int i;
    static char buf[40];
    static char count = 0;
    
    // serial control
    if (pc.readable()) {
        i = pc.getc();
        if (i == 0x0d || i == 0x0a) {
            buf[count] = 0;
            count = 0;
            led3 = 0;
            if (command(buf)) {
                led3 = 1;
            }
        } else
        if (i >= 0x20 && i < 0x7f && count < sizeof(buf) - 1) {
            buf[count] = i;
            count ++;
        }
    }
}

int main(int argc, char *argv[])
{
    int i;

    pc.baud(115200);
    pc.printf("madplayer LPC4088\r\n");
    ticker.attach(&isr_ticker, 0.01);
    wait_ms(100);
    if (init_audio()) return -1;

    led1 = 0;
    led2 = 1;

    for (;;) {
        poll();
    }
}
