/*
 * syslog device library
 * Copyright (c) 2011 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

/** @file logger.h
 * @brief syslog device (sender/client)
 */
 
#ifndef LOGGER_H
#define LOGGER_H

#include "mbed.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"

#define LOG_LEN 256
#define LOG_UDPPORT 514

/**
 * @enum Severity of priority
 */
enum LOG_SEVERITY {
    LOG_EMERG    = 0,    /* system is unusable */
    LOG_ALERT    = 1,    /* action must be taken immediately */
    LOG_CRIT    = 2,    /* critical conditions */
    LOG_ERR        = 3,    /* error conditions */
    LOG_WARNING    = 4,    /* warning conditions */
    LOG_NOTICE    = 5,    /* normal but significant condition */
    LOG_INFO    = 6,    /* informational */
    LOG_DEBUG    = 7,    /* debug-level messages */
};

/**
 * @enum Facility of priority
 */
enum LOG_FACILITY {
    LOG_KERN    = 0,    /* kernel messages */
    LOG_USER    = 1,    /* user-level messages */
    LOG_MAIL    = 2,    /* mail system */
    LOG_DAEMON    = 3,    /* system daemons */
    LOG_AUTH    = 4,    /* authorization messages */
    LOG_SYSLOG    = 5,    /* messages generated internally by syslogd */
    LOG_LPR        = 6,    /* line printer subsystem */
    LOG_NEWS    = 7,    /* network news subsystem */
    LOG_UUCP    = 8,    /* UUCP subsystem */
    LOG_CRON    = 9,    /* clock daemon */
    LOG_AUTHPRIV    = 10,    /* authorization messages = private */
    LOG_FTP        = 11,    /* ftp daemon */
    LOG_NTP        = 12,    /* NTP subsystem */
    LOG_SECURITY    = 13,    /* security subsystems (audit) */
    LOG_CONSOLE    = 14,    /* /dev/console output (alert) */
    LOG_CLOCK    = 15,    /* clock daemon */
    LOG_LOCAL0    = 16,    /* reserved for local use */
    LOG_LOCAL1    = 17,    /* reserved for local use */
    LOG_LOCAL2    = 18,    /* reserved for local use */
    LOG_LOCAL3    = 19,    /* reserved for local use */
    LOG_LOCAL4    = 20,    /* reserved for local use */
    LOG_LOCAL5    = 21,    /* reserved for local use */
    LOG_LOCAL6    = 22,    /* reserved for local use */
    LOG_LOCAL7    = 23,    /* reserved for local use */
};

/** brief syslog device (sender/client)
 */
class logger {
public:
    /** init logger class
     * @param p_eth EthernetNetIf class
     * @param host syslog collctor (server)
     */
    logger (EthernetNetIf *, char *); 

    /** init logger class
     * @param p_eth EthernetNetIf class
     * @param host syslog collctor (server) hostname or IP address
     * @param myname My hostname or IP address
     */
    logger (EthernetNetIf *, char *, char *);

    /** Send the message
     * @param tag Process name
     * @param content Message
     */
    void send (LOG_SEVERITY, LOG_FACILITY, char *, char *);

    /** Send the message
     * @param sev Severity
     * @param fac Facility
     * @param tag Process name
     * @param content Message
     */
    void send (char *, char *);

private:
    EthernetNetIf *eth;
    UDPSocket *udpsock;
    Host remote;

    char ident[32];

};

#endif

