#include "mbed.h"

#define CMD_WREN    0x06    // Write enable
#define CMD_WRDI    0x04    // Write disable
#define CMD_RDID    0x9f    // Read identification 
#define CMD_RDSR    0x05    // Read status register
#define CMD_WRSR    0x01    // Write status registe
#define CMD_READ    0x03    // Read data bytes
#define CMD_FREAD   0x0b    // Read data bytes at higher speed
#define CMD_PP      0x02    // Page program (legacy program)
#define CMD_PP_BA   0x22    // Page program (bit-alterable write)
#define CMD_PP_1S   0xd1    // Page program (On all 1s)
#define CMD_SE      0xd8    // Sector erase

class PRAM {
public:
    PRAM (PinName mosi, PinName miso, PinName sclk, PinName cs);
    PRAM (SPI &spi, PinName cs);
    
    int status ();
    int write (int addr, char *buf, int len);
    int read (int addr, char *buf, int len);

private:
    SPI _spi;
    DigitalOut _cs;
};
