#include "mbed.h"
#include "PRAM.h"


PRAM::PRAM (SPI &spi, PinName cs) : _spi(spi), _cs(cs) {
    int i;

    _cs = 1;
    _spi.frequency(16000000);
    wait_ms(10);
    
    _cs = 0;
    _spi.write(CMD_RDID);
    printf("RAM Manufacturer ID : %02x\r\n", spi.write(0));
    i = (spi.write(0) << 8) | spi.write(0);
    printf("RAM Device ID : %04x\r\n", i);
    _cs = 1;
}

PRAM::PRAM (PinName mosi, PinName miso, PinName sclk, PinName cs) : _spi(mosi, miso, sclk), _cs(cs) {
}

int PRAM::status () {
    int r;

    _cs = 0;
    _spi.write(CMD_RDSR);
    r = _spi.write(0);
    _cs = 1;
    return r;
}

int PRAM::write (int addr, char *buf, int len) {
    int i;

    while (status() & 1) {
        // write in progress
        wait_us(1);
    }

    _cs = 0;
    _spi.write(CMD_WREN);
    _cs = 1;
    wait_us(1);

    _cs = 0;
    _spi.write(CMD_PP_BA);
    _spi.write((addr >> 16) & 0xff);
    _spi.write((addr >> 8) & 0xff);
    _spi.write(addr & 0xff);

    len = len - (addr & 0x3f);
    for (i = 0; i < len; i ++) {
        _spi.write(buf[i]);
    }
    _cs = 1;
    return i;
}

int PRAM::read (int addr, char *buf, int len) {
    int i;

    while (status() & 1) {
        // write in progress
        wait_us(1);
    }

    _cs = 0;
    _spi.write(CMD_READ);
    _spi.write((addr >> 16) & 0xff);
    _spi.write((addr >> 8) & 0xff);
    _spi.write(addr & 0xff);

    for (i = 0; i < len; i ++) {
        buf[i] = _spi.write(0);
    }
    _cs = 1;
    return i;
}
