/*
 * libmad - MPEG audio decoder library
 * Copyright (C) 2000-2004 Underbit Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/
/************************************************************************/
/* This library has been changed by Andreas Gruen to work on an LPC1768
 * Because the available RAM is too small for decoding, it uses 
 * some of the AHB-RAM dedicated to the Ethernet peripheral to
 * store parts of the mad_decoder structure.
 * Therefore the Ethernet module cannot be used !
 * The address is defined by AHBMEM below, ~12kByte are used
 * All other changes are made only to satisfy the mbed online compiler,
 * which treats all files as C++ code and does not allow additional 
 * defines on the command line.
 * The changes are: 
 *     forced inclusion of "config.h" in all files
 *  forced inclusion of "mbed.h" in all files via "config.h"
 *    typecasts from void *
 *     renaming of all .c-Files to .cpp
 *     renaming of all .dat-Files to .h 
 *
 * The exact changes can bee seen by a diff-tool comparing with 
 * the libmad-0.15.1b source.
 * This modified version does no longer compile for other systems.
 * There are still one compiler warning that can be ignored.
 */

# ifndef LIBMAD_CONFIG_H
# define LIBMAD_CONFIG_H

#if defined(TARGET_LPC1768)
#include "mbed.h"
void *mad_malloc(unsigned int sz);
void reset_ahb_mem(void);
#endif

/* config.h.  Generated by configure.  */
/* config.h.in.  Generated from configure.ac by autoheader.  */


/* used by USB
#define AHBMEM ((void *)0x2007C000)   */

/* used by ethernet */
#define AHBMEM ((void *)0x20080000)
#define AHBMEMSIZE 16300

#define FPM_DEFAULT
/* Define to enable diagnostic debugging support. */
/* #undef DEBUG */

/* Define to enable experimental code. */
/* #undef EXPERIMENTAL */

/* Define to 1 if you have the <assert.h> header file. */
/*#define HAVE_ASSERT_H 1*/

/* Define to 1 if you have the <dlfcn.h> header file. */
/* #undef HAVE_DLFCN_H */

/* Define to 1 if you have the <errno.h> header file. */
/* #define HAVE_ERRNO_H 1*/

/* Define to 1 if you have the `fcntl' function. */
/* #undef HAVE_FCNTL */

/* Define to 1 if you have the <fcntl.h> header file. */
/* #define HAVE_FCNTL_H 1*/

/* Define to 1 if you have the `fork' function. */
/* #undef HAVE_FORK */

/* Define to 1 if you have the <inttypes.h> header file. */
/* #define HAVE_INTTYPES_H 1*/

/* Define to 1 if you have the <limits.h> header file. */
/* #define HAVE_LIMITS_H 1*/ 

/* Define if your MIPS CPU supports a 2-operand MADD16 instruction. */
/* #undef HAVE_MADD16_ASM */

/* Define if your MIPS CPU supports a 2-operand MADD instruction. */
/* #undef HAVE_MADD_ASM */

/* Define to 1 if you have the <memory.h> header file. */
/* #define HAVE_MEMORY_H 1 */

/* Define to 1 if you have the `pipe' function. */
/* #undef HAVE_PIPE */

/* Define to 1 if you have the <stdint.h> header file. */
/* #define HAVE_STDINT_H 1*/

/* Define to 1 if you have the <stdlib.h> header file. */
#define HAVE_STDLIB_H 1

/* Define to 1 if you have the <strings.h> header file. */
#define HAVE_STRINGS_H 1

/* Define to 1 if you have the <string.h> header file. */
/* #define HAVE_STRING_H 1 */

/* Define to 1 if you have the <sys/stat.h> header file. */
/* #define HAVE_SYS_STAT_H 1*/

/* Define to 1 if you have the <sys/types.h> header file. */
/* #define HAVE_SYS_TYPES_H 1*/

/* Define to 1 if you have <sys/wait.h> that is POSIX.1 compatible. */
/* #undef HAVE_SYS_WAIT_H */

/* Define to 1 if you have the <unistd.h> header file. */
/* #undef HAVE_UNISTD_H */

/* Define to 1 if you have the `waitpid' function. */
/* #undef HAVE_WAITPID */

/* Define to disable debugging assertions. */
/* #undef NDEBUG */

/* Define to optimize for accuracy over speed. */
/* #undef OPT_ACCURACY */

/* Define to optimize for speed over accuracy. */
/* #define OPT_SPEED */

/* Define to enable a fast subband synthesis approximation optimization. */
/* #define OPT_SSO */

/* Define to influence a strict interpretation of the ISO/IEC standards, even
   if this is in opposition with best accepted practices. */
/* #undef OPT_STRICT */

/* Name of package */
#define PACKAGE "libmad"

/* Define to the address where bug reports for this package should be sent. */
#define PACKAGE_BUGREPORT "support@underbit.com"

/* Define to the full name of this package. */
#define PACKAGE_NAME "MPEG Audio Decoder"

/* Define to the full name and version of this package. */
#define PACKAGE_STRING "MPEG Audio Decoder 0.15.1b"

/* Define to the one symbol short name of this package. */
#define PACKAGE_TARNAME "libmad"

/* Define to the version of this package. */
#define PACKAGE_VERSION "0.15.1b"

/* The size of a `int', as computed by sizeof. */
#define SIZEOF_INT 4

/* The size of a `long', as computed by sizeof. */
#define SIZEOF_LONG 4

/* The size of a `long long', as computed by sizeof. */
#define SIZEOF_LONG_LONG 8

/* Define to 1 if you have the ANSI C header files. */
#define STDC_HEADERS 1

/* Version number of package */
#define VERSION "0.15.1b"

/* Define to empty if `const' does not conform to ANSI C. */
/* #undef const */

/* Define as `__inline' if that's what the C compiler calls it, or to nothing
   if it is not supported. */
#define inline 

/* Define to `int' if <sys/types.h> does not define. */
/* #undef pid_t */


/* Define mad_malloc to malloc if no special mem handling required */

#endif
