#include "mbed.h"
#include "TLV320.h"

#define BUF_SIZE 4000

Serial pc(USBTX, USBRX);
TLV320 audio(p9, p10, 0x34, p5, p6, p7, p8, p16); // I2S Codec
DigitalOut myled(LED1);

volatile int count = 0;
int addr = 0;
int buffer[BUF_SIZE];

// interrupt TLV320 send/recv
void isr_audio () {
    int i, a;
    short l, r, ll, rr;
    int buf[4];

    // I2S input
    audio.read();
    for (i = 0; i < 4; i ++) {
        buf[i] = audio.rxBuffer[i];
    }

    for (i = 0; i < 4; i ++) {
        l = (buffer[addr + i] >> 16);
        r = (buffer[addr + i] & 0xffff);
        ll = (buf[i] >> 16);
        rr = (buf[i] & 0xffff);
        l = (ll * 0.66) + (l * 0.33);
        r = (rr * 0.66) + (r * 0.33);
        buffer[addr + i] = buf[i];
        buf[i] = (l << 16) | (r & 0xffff);
    }
    addr += 4;
    if (addr >= BUF_SIZE) addr = 0;

    audio.write(buf, 0, 4);

    count ++;
}

int main() {
    int time = 0;

    pc.baud(115200);
    memset(buffer, 0, sizeof(buffer));

    audio.power(0x02); // mic off
    audio.outputVolume(1, 1); // headphone off
    audio.inputVolume(1, 1);
    audio.frequency(44100);
    audio.attach(&isr_audio);
    audio.start(RECEIVE);
    printf("Audio ready\r\n");

    while (1) {
        printf("%d / %d\r\n", time, count);
        printf("L %04x / R %04x\r\n", (buffer[0] >> 16), (buffer[0] & 0xffff));
        time ++;

        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);

//        if (pc.readable()) break;
    }

    audio.stop();
    printf("exit\r\n");
}
