#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
EthernetInterface eth;

volatile int count = 0, num = 0, reset = 0;
volatile int ref = 123456; // no rtos = 8727224

extern "C"
void os_idle_demon (void) {
    for (;;) {
        if (reset) {
            count = 0;
            reset = 0;
        } else {
            count ++;
        }
    }
}

void isr_timer () {
    num = count;
    reset = 1;
    myled = 1;
}

void dummy_task (const void *args) {
    volatile int w;
    for (;;) {
        for (w = 0; w < 10000; w ++);
        Thread::wait(10);
    }
}

int main() {
    Ticker timer;

    pc.baud(115200);
    pc.printf("LOAD TESTING\r\n");
    pc.printf("system clock: %d\r\n", SystemCoreClock);

    timer.attach(&isr_timer, 1);

    pc.printf("wait...\r\n");
    while (!num) {
        Thread::wait(100);
    }
    pc.printf("   dummy %d%0.1f dummy      \r\n", num, (float)num / ref * 100);
    num = 0;
    for (;;) {
        if (num) {
            pc.printf("reference count: %d /sec\r\n", num);
            ref = num;
            num = 0;
            break;
        }
        Thread::wait(100);
    }

    pc.printf("ethernet...\r\n");
    eth.init(); //Use DHCP
    if (eth.connect()) {
        pc.printf("error\r\n");
        return -1;
    }
    pc.printf("IP: %s\r\n", eth.getIPAddress());

//    Thread thread1(dummy_task);

    num = 0;
    for (;;) {
        if (num) {
            pc.printf("idle count: %d /sec (%0.1f %%)\r\n", num, (float)num / ref * 100);
            num = 0;
            myled = 0;
        }
        Thread::wait(100);
    }
}
