// OKANO's IAP code from
// http://mbed.org/users/okano/notebook/iap-in-application-programming-internal-flash-eras/
/**
 * @file
 */

#include "mbed.h"
#include "eeprom.h"

enum command_code
        {
            IAPCommand_EEPROM_Write = 61,
            IAPCommand_EEPROM_Read,
        };

#define     IAP_LOCATION    0x1fff1ff1
typedef     void (*IAP_call)(unsigned int [], unsigned int []);

IAP_call        iap_entry = reinterpret_cast<IAP_call>(IAP_LOCATION);
unsigned int    IAP_command[ 5 ];
unsigned int    IAP_result[ 5 ];
int             cclk_kHz = SystemCoreClock / 1000;

/** Copy RAM to EEPROM (LPC11U24)
 *  
 *  @param    source_addr    Source RAM address from which data bytes are to be read.
 *  @param    target_addr    Destination EEPROM address where data bytes are to be written.
 *  @param    size           Number of bytes to be written.
 *  @return   error code: CMD_SUCCESS | SRC_ADDR_NOT_MAPPED | DST_ADDR_NOT_MAPPED
 *  Remark: The top 64 bytes of the EEPROM memory are reserved and cannot be written to.
 */
int write_eeprom( char *source_addr, char *target_addr, int size ) {
    IAP_command[ 0 ]    = IAPCommand_EEPROM_Write;
    IAP_command[ 1 ]    = (unsigned int)target_addr;    //  Destination EEPROM address where data bytes are to be written. This address should be a 256 byte boundary.
    IAP_command[ 2 ]    = (unsigned int)source_addr;    //  Source RAM address from which data bytes are to be read. This address should be a word boundary.
    IAP_command[ 3 ]    = size;                         //  Number of bytes to be written. Should be 256 | 512 | 1024 | 4096.
    IAP_command[ 4 ]    = cclk_kHz;                     //  CPU Clock Frequency (CCLK) in kHz.

    iap_entry( IAP_command, IAP_result );

    return ( (int)IAP_result[ 0 ] );
}

/** Copy EEPROM to RAM (LPC11U24)
 *  
 *  @param    source_addr    Source EEPROM address from which data bytes are to be read.
 *  @param    target_addr    Destination RAM address where data bytes are to be written.
 *  @param    size           Number of bytes to be written.
 *  @return   error code: CMD_SUCCESS | SRC_ADDR_NOT_MAPPED | DST_ADDR_NOT_MAPPED
 *  Remark: The top 64 bytes of the EEPROM memory are reserved and cannot be written to.
 */
int read_eeprom( char *source_addr, char *target_addr, int size ) {
    IAP_command[ 0 ]    = IAPCommand_EEPROM_Read;
    IAP_command[ 1 ]    = (unsigned int)source_addr;    //  Source EEPROM address from which data bytes are to be read. This address should be a word boundary.
    IAP_command[ 2 ]    = (unsigned int)target_addr;    //  Destination RAM address where data bytes are to be written. This address should be a 256 byte boundary.
    IAP_command[ 3 ]    = size;                         //  Number of bytes to be written. Should be 256 | 512 | 1024 | 4096.
    IAP_command[ 4 ]    = cclk_kHz;                     //  CPU Clock Frequency (CCLK) in kHz.

    iap_entry( IAP_command, IAP_result );

    return ( (int)IAP_result[ 0 ] );
}
