/**
 * DAISEN eDES 2WD driver for mbed
 * Copyright (c) 2012 Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

/** @file
 * @brief DAISEN eDES 2WD driver for mbed
 */

#define SUB_ADRS    0x30

#define I2C_WCMD_RESET    0x00
#define I2C_WCMD_START    0x01
#define I2C_WCMD_ENQ    0x09

#define I2C_WCMD_IO        0x10
#define I2C_WCMD_SENSOR    0x11
#define I2C_WCMD_MOTOR    0x12
#define I2C_WCMD_LED    0x13
#define I2C_WCMD_LAT    0x14
#define I2C_WCMD_T        0x15
#define I2C_WCMD_V        0x16
#define I2C_WCMD_DIR    0x17
#define I2C_WCMD_EG002    0x18
#define I2C_WCMD_EG003    0x19
#define I2C_WCMD_EG009    0x1A
#define I2C_WCMD_LDM    0x1B

#define I2C_RCMD_IO        0x80
#define I2C_RCMD_SENSOR    0x81
#define I2C_RCMD_MOTOR    0x82
#define I2C_RCMD_LED    0x83
#define I2C_RCMD_LAT    0x84
#define I2C_RCMD_T        0x85
#define I2C_RCMD_V        0x86
#define I2C_RCMD_DIR    0x87

#define MAX_PWM            6
#define MAX_COL            16

#define MAX_CN        10

#define eDES2WD_ID 1

enum eDES2WD_LED {
    LED_GREEN = 0,
    LED_RED,
    LED_LEFT,
    LED_RIGHT,
};

enum eDES2WD_SENSOR {
    SENSOR_WALL_CENTER = 0,
    SENSOR_WALL_LEFT,
    SENSOR_WALL_RIGHT,
    SENSOR_FLOOR_CENTER,
    SENSOR_FLOOR_LEFT,
    SENSOR_FLOOR_RIGHT,
};

class eDES2WD {
public:
    eDES2WD (I2C &i2c);
    void reset (int id);
    void motor (int id, int l_speed, int r_speed);
    void set_led (int id, eDES2WD_LED led, int sw);

    unsigned int get_sensor(int id, eDES2WD_SENSOR cn, unsigned int *dat);
    int get_lat(int id, int cno);

private:
    I2C _i2c;

};
