#include "mbed.h"
#include "DMX.h"

//DMX dmx0(p9, p10);
DMX dmx1(p13, p14);
DMX dmx2(p28, p27);

AnalogIn adc(p15);
Serial pc(USBTX, USBRX);
PwmOut led_r(p22), led_y(p23);

int main() {
    int i, n;

    dmx1.start();
    dmx2.start();

    for (i = 0; i < 512; i ++) {
        dmx1.put(i, i & 0xff);
        dmx2.put(i, 255 - (i & 0xff));
    }

    while(1) {
        n = 1;
        for (i = 0; i < 512; i ++) {
            if (dmx1.get(i) != (i & 0xff)) {
                n = 0;
            }
        }
        led_y = n;

        n = 1;
        for (i = 0; i < 512; i ++) {
            if (dmx2.get(i) != 255 - (i & 0xff)) {
                n = 0;
            }
        }
        led_r = n;
    }
}