#include "mbed.h"

#define R0 (1<<0) // P2.0 (p26)
#define G0 (1<<1) // P2.1 (p25)
#define B0 (1<<2) // P2.2 (p24)
#define R1 (1<<3) // P2.3 (p23)
#define G1 (1<<4) // P2.4 (p22)
#define B1 (1<<5) // P2.5 (p21)
#define A  (1<<4) // P0.4 (p30)
#define B  (1<<5) // P0.5 (p29)
#define C  (1<<10) // P0.10 (p28)
#define D  (1<<11) // P0.11 (p27)
#define CLK (1<<24) // P0.24 (p16)
#define STB (1<<25) // P0.25 (p17)
#define OE  (1<<26) // P0.26 (p18)

#define P0_MASK (A|B|C|D|CLK|STB|OE)
#define P2_MASK (R0|G0|B0|R1|G1|B1)

DigitalOut myled(LED1);

uint32_t data[32][32];
int line = 0, pwm = 0;

void isrTimer () {
    uint32_t p0, p2;
    int i, rgb;

    LPC_GPIO0->FIOMASK = ~P0_MASK;
    LPC_GPIO2->FIOMASK = ~P2_MASK;

    p0 = ((line << 8) & (C|D)) | ((line << 4) & (A|B)) | OE;
    LPC_GPIO0->FIOPIN = p0;

    for (i = 0; i < 32; i ++) {
        p2 = 0;
        rgb = data[line][i];
        if ((rgb         & 0xff) > pwm) p2 |= R0;
        if (((rgb >>  8) & 0xff) > pwm) p2 |= G0;
        if (((rgb >> 16) & 0xff) > pwm) p2 |= B0;
        rgb = data[line + 16][i];
        if ((rgb         & 0xff) > pwm) p2 |= R1;
        if (((rgb >>  8) & 0xff) > pwm) p2 |= G1;
        if (((rgb >> 16) & 0xff) > pwm) p2 |= B1;
        LPC_GPIO2->FIOPIN = p2;

        p0 |= CLK;
        LPC_GPIO0->FIOPIN = p0;
        p0 &= ~CLK;
        LPC_GPIO0->FIOPIN = p0;
    }

    p0 |= STB;
    LPC_GPIO0->FIOPIN = p0;
    p0 &= ~(STB|OE);
    LPC_GPIO0->FIOPIN = p0;

    pwm += 32;
    if (pwm > 256) {
        pwm = 0;
        line ++;
        if (line >= 16) {
            line = 0;
        }
    }

    LPC_GPIO0->FIOMASK = 0;
    LPC_GPIO2->FIOMASK = 0;
}

int main() {
    Ticker t;
    int x, y, r, g, b;

    LPC_GPIO0->FIODIR = P0_MASK;
    LPC_GPIO2->FIODIR = P2_MASK;
    LPC_GPIO0->FIOSET = OE;
    memset(data, 0, sizeof(data));

    t.attach_us(&isrTimer, 50);

    for (;;) {
        x = 32.0 * rand() / RAND_MAX;
        y = 32.0 * rand() / RAND_MAX;
        r = 255.0 * rand() / RAND_MAX;
        g = 255.0 * rand() / RAND_MAX;
        b = 255.0 * rand() / RAND_MAX;
        data[y][x] = (b << 16) | (g << 8) | r;
        wait_ms(5);
    }
}
