#include "mbed.h"
#include "EthernetInterface.h"
#include "TinyHTTP_b.h"

// Kansai Electric Power
#define HTTP_HOST "www.kepco.co.jp"
#define HTTP_URI "/yamasou/juyo1_kansai.csv"

Serial pc(USBTX, USBRX);
EthernetInterface eth;

DigitalOut led1(LED1);
PwmOut led2(LED2), led3(LED3), led4(LED4);

volatile int denki_flg = 0;
volatile int denki_capacity = 0;
volatile int denki_usage = 0;
volatile int year, month, day, hour, minute;


void callback_denkiyohou (char *buf, int len) {
    static int n = 0;
    static char data[100];
    int i;

    for (i = 0; i < len; i ++) {
        if (buf[i] == '\r') continue;

        if (denki_flg <= 1) {
            // header
            if (buf[i] == '\n') {
                n = 0;
                denki_flg ++;
            } else {
                denki_flg = 0;
            }
            continue;
        }

        // body        
        if (buf[i] == '\n') {
            data[n] = 0;
            switch (denki_flg) {
            case 2:
                // update
                break;
            case 4:
                // capacity
                if (data[0] >= '0' && data[0] <= '9') {
                    denki_capacity = atoi(data);
                }
                break;
            case 7:
                // yosou1
                break;
            case 10:
                // yosou2
                break;
            default:
                // text
                if (data[0] == 'D' && data[1] == 'A') {
                    denki_flg = denki_flg < 100 ? 100 : 200;
                }
                break;
            }
            if (denki_flg > 200 && data[n - 1] >= '0' && data[n - 1] <= '9') {
                sscanf(data, "%d/%d/%d,%d:%d,%d", &year, &month, &day, &hour, &minute, &denki_usage);
            }
            n = 0;
            denki_flg ++;
        } else {
            // data
            if (n < sizeof(data) - 1) {
                data[n] = buf[i];
                n ++;
            }
        }

    }
}

int main() {
    Timer timer;
    int flg = 1, r;
    float denki_percentage = 0;

    pc.baud(115200);
    eth.init(); //Use DHCP
    if (eth.connect()) {
        return -1;
    }
    
    pc.printf("Denki-yohou: %s\r\n", HTTP_HOST);

    timer.start();
    while(1) {
        led1 = 1;
    
        if (flg || timer.read() >= 180) { // 3min
            timer.reset();
            denki_flg = 0;
            r = httpRequest(METHOD_GET, HTTP_HOST, 80, HTTP_URI, NULL, NULL, &callback_denkiyohou);
            if (r == 0) {
                denki_percentage = (float)denki_usage / (float)denki_capacity * 100.0;
                
                pc.printf("%04d-%02d-%02d %02d:%02d :", year, month, day, hour, minute);
                pc.printf(" %d0 MW / %d0 MW", denki_usage, denki_capacity);
                pc.printf(" (%0.1f %%)\r\n", denki_percentage);
                
                led2 = denki_percentage >= 70 ? (denki_percentage >= 77.5 ? 1 : 0.5) : 0;
                led3 = denki_percentage >= 85 ? (denki_percentage >= 90 ? 1 : 0.5) : 0;
                led4 = denki_percentage >= 95 ? (denki_percentage >= 97 ? 1 : 0.5) : 0;
            } else {
                pc.printf("http error\r\n");
            }
            flg = 0;
        }

        wait(0.1);
        led1 = 0;
        wait(0.9);
    }
}
