#include "mbed.h"
#include "DALI.h"

#define DALI_ADDRESS 1

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
DALI dali(p22, p21); // tx, rx

int main() {

    pc.baud(115200);
    pc.printf("DALI sample\r\n");
    led1 = 1;

    for (;;) {
        if (dali.readable()) {
            int f, a, v;
            led3 = 1;
            dali.read((enum DALI::DALI_FRAME*)&f, &a, &v);
            pc.printf("recv f=%d a=%d v=%d\r\n", f, a, v);
        }

        if (pc.readable()) {
            char c = pc.getc();
            led4 = 1;
            if (c >= '0' && c <= '9') {
                dali.write(DALI::FORWARD_SHORT_DAP, DALI_ADDRESS, (c - '0') * 20);
                dali.write(DALI::FORWARD_GROUP_DAP, DALI_ADDRESS, (c - '0') * 20);
            } else
            if (c == ' ') {
                dali.write(DALI::FORWARD_SHORT_DAP, DALI_ADDRESS, 255);
            } else
            if (c == 'a') {
                dali.write(DALI::FORWARD_SHORT_IAP, DALI_ADDRESS, DALI::OFF); // OFF
            } else
            if (c == 'b') {
                dali.write(DALI::FORWARD_SHORT_IAP, DALI_ADDRESS, DALI::RECALL_MAX_LEVEL); // RECALL_MAX_LEVEL
            } else
            if (c == 'c') {
                dali.write(DALI::FORWARD_SHORT_IAP, DALI_ADDRESS, DALI::QUERY_STATUS); // QUERY_STATUS
            } else
            if (c == 'd') {
                dali.write(DALI::FORWARD_GROUP_DAP, 63, 127);
            }
        }

        wait_ms(1);
        led2 = ! led2;
        led3 = led4 = 0;
    }
}
