#include "mbed.h"
#include "XBee.h"

DigitalOut myled(LED1);
XBee xbee(p13, p14);
XBeeAddress64 remoteAddress = XBeeAddress64(0x0013A200, 0x40319F25);

int main() {
    uint8_t Cmd[] = {'D', '4'};
    uint8_t Low[] = {0x04};
    uint8_t High[] = {0x05};
    RemoteAtCommandRequest remoteAtRequest;

    wait(1);
    xbee.begin(9800);

    remoteAtRequest = RemoteAtCommandRequest(remoteAddress, Cmd, Low, sizeof(Low));
    remoteAtRequest.setApplyChanges(true);

    while(1) {
        myled = 1;
        remoteAtRequest.setCommandValue(Low);
        remoteAtRequest.setCommandValueLength(sizeof(Low));
        xbee.send(remoteAtRequest);
        myled = 0;
        wait(1);

        myled = 1;
        remoteAtRequest.setCommandValue(High);
        remoteAtRequest.setCommandValueLength(sizeof(High));
        xbee.send(remoteAtRequest);
        myled = 0;
        wait(1);
    }
}
