/* mbed module to use a Sensirion SHT1x /SHT7x sensor
 * Copyright (c) 2007-2009 Stephen McGarry
 * Released under the MIT License: http://mbed.org/license/mit
 */
#ifndef SHT_H
#define SHT_H

#include "mbed.h"

enum SHT_acc {
    SHT_low=0,
    SHT_high=1
};

typedef unsigned char byte;

class SHT : public Base {
public:
    /* Constructor: SHT
     *  Creates an SHT interface connected to specific pins.
     *
     */
    SHT(PinName p_sclk, PinName p_data, SHT_acc p_accuracy);

    /* Functions
     */
    float get_temperature();     // get the most recent temp reading
    float get_humidity();        // get the most recent humidity reading
    float get_dewpoint();        // get the most recent dewpoint value
    void update(SHT_acc accuracy); // update stored values from sensor

protected:
    byte read_byte(bool send_ack);
    char write_byte(byte value);
    void trans_start(void);
    void connection_reset(void);
    char soft_reset();
    char read_status(byte &value);
    char write_status(byte value);
    char measure(int &value, byte mode);
    void calculate();

    DigitalOut sclk;
    DigitalInOut data;
    SHT_acc accuracy;    // will we use high or low accuracy mode on the sensor

    float temperature;    // calculated from sensor reading
    float humidity;
    float dewpoint;
    int temp,hum;        // integer values from sensor before conversion

    enum commands {
        com_read_status_reg=0x06,
        com_write_status_reg=0x07,
        com_measure_temp=0x03,
        com_measure_humid=0x05,
        com_reset=0x1E
    };

    enum acks {
        no_ack=0,
        send_ack=1
    };
};

#endif