/*
 * Weather Station - mbed Weather Platform
 * Copyright (c) 2011 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

/** @file
 * @brief Weather Station
 */

#include "mbed.h"
#include "weather.h"
#ifdef USE_DISPLAY
#include "I2CLEDDisp.h"
#include "I2CLCD.h"

static I2CLEDDisp *leddisp;
static I2CLCD *lcd;
static volatile int leddisp_freq = 0, leddisp_pos = -4;
static char leddisp_buf[FORMAT_STR_SIZE];
#endif

void update_display () {
#ifdef USE_DISPLAY
    char buf[FORMAT_STR_SIZE];

    if (conf.leddisp_mesg[0]) {
        format_str(conf.leddisp_mesg, leddisp_buf, sizeof_1(leddisp_buf));
    }

    if (conf.lcd_mesg[0]) {
        format_str(conf.lcd_mesg, buf, sizeof_1(buf));
        lcd->cls();
        lcd->puts(buf);
    }
#endif
}

void pool_display () {
#ifdef USE_DISPLAY
    int i, addr, len;

    // LED Display scroll
    if (conf.leddisp_mesg[0]) {
        leddisp_freq ++;
        if (leddisp_freq > LED_FREQ) {

            len = strlen(leddisp_buf);
            leddisp->locate(0, 0);
            for (i = 0; i < 4; i ++) {
                addr = leddisp_pos + i;
                if (addr >= 0 && addr < len) {
                    leddisp->putc(leddisp_buf[addr]);
                } else {
                    leddisp->putc(' ');
                }
            }

            leddisp_pos ++;
            if (leddisp_pos >= len + 4) {
                leddisp_pos = -4;
            }

            leddisp_freq = 0;
        }
    }
#endif
}

int init_display () {
#ifdef USE_DISPLAY

    if (conf.lcd_mesg[0]) {
        lcd = new I2CLCD(i2c, I2CLCD_ADDR, conf.lcdtype, conf.lcdconf);
#ifdef DEBUG
        printf("LCD: %s\r\n", conf.lcd_mesg);
#endif
    }

    if (conf.leddisp_mesg[0]) {
        leddisp = new I2CLEDDisp(i2c);
        strncpy(leddisp_buf, VERSION, sizeof_1(leddisp_buf));
#ifdef DEBUG
        printf("LED disp: %s\r\n", conf.leddisp_mesg);
#endif
    }

#endif
    return 0;
}
