#include "mbed.h"
#include "BMP085.h"
#include "SHT.h"
#include "WeatherMeters.h"
//#include "I2CLCD.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

// Pachube API key
#define apiKey "xxxxxxxxxxxxxxxxxxxxxx"
// Pachube feed ID
#define environmentID "0000"

I2C i2c(p9, p10);

BMP085 bmp085(i2c, BMP085_oss4);
//I2CLCD i2clcd(i2c);
SHT sht11(p12, p11, SHT_high); // sclock, data
WeatherMeters wmeters(p21, p15, p22); // anemo, vane, rain

DigitalOut led1(LED1), led2(LED2), led3(LED3);

Serial pc(USBTX, USBRX);
AnalogIn photo(p16);
AnalogIn moist(p18);
AnalogIn uv(p17);

EthernetNetIf eth;
HTTPClient client;

float get_photo (AnalogIn &ain) {
    float f;
    
    f = ain * 5.0 / 1000; // A
    return f / 0.0000026; // lx
}

float get_moist (AnalogIn &ain) {
    float f;
    
    f = ain * 5.0; // V
    return f / ((3.3 - f) / 10.0); // k ohm
}

float get_uv (AnalogIn &ain) {
    float f;
    
    f = ain * 5.0 / 100000; // A
    return f / 0.000384; // mW/cm2
}

int main() {
    float p, t, h, b, a, v, r, m, u;
    Timer timer;
    
    led1 = 1;

    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    } else {
        led2 = 1;
    }

    timer.start();
    
    while(1) {
        led1 = 0;

        bmp085.update();
        p = bmp085.get_pressure();
        pc.printf("p:%6.2f hPa / t:%6.2f C\n", p, bmp085.get_temperature());

        sht11.update(SHT_high);
        t = sht11.get_temperature();
        h = sht11.get_humidity();
        pc.printf("t:%6.2f C / h:%6.2f %%\n", t, h);

        a = wmeters.get_windspeed();
        v = wmeters.get_windvane();
        r = wmeters.get_raingauge();
        pc.printf("a:%6.2f m/s / v:%6.2f / r:%6.2f mm\n", a, v, r);

        b = get_photo(photo);
        pc.printf("b:%6.2f lx\n", b);
        m = get_moist(moist);
        pc.printf("m:%6.2f k ohm\n", m);
        u = get_uv(uv);
        pc.printf("u:%6.2f mW/cm2\n", u);
/*
        i2clcd.locate(0, 0);
        i2clcd.printf("%4.1f hPa", p);
        i2clcd.locate(0, 1);
        i2clcd.printf("%2.1f C / %2.1f %%", t, h);
*/

        {
            char uri[100], data[100];
            HTTPResult result;
            int response;
            HTTPText csvContent("text/csv");

            led3 = 1;
            sprintf(data, "%f,%f,%f,%f,%f,%f\r\n", p, t, h, a, v, r);
            client.setRequestHeader("X-PachubeApiKey", apiKey);
            csvContent.set(data);
            strcpy(uri, "http://api.pachube.com/v1/feeds/" environmentID ".csv?_method=put");
            result = client.post(uri, csvContent, NULL);
            response = client.getHTTPResponseCode();
            led3 = 0;
        }

        led1 = 1;

        while (timer.read() < 60);
        timer.reset();
    }
}
