/**
* Agentbed SNMP Server
*  Modified for mbed, 2011 Suga.
*
* Agentuino SNMP Agent Library Prototyping...
* Copyright 2010 Eric C. Gionet <lavco_eg@hotmail.com>
*/
#include "mbed.h"
#include "Agentbed.h"
#include "EthernetNetIf.h"
#include "ConfigFile.h"
#include "conf.h"

AgentbedClass Agentbed;

// RFC1213-MIB OIDs
// .iso (.1)
// .iso.org (.1.3)
// .iso.org.dod (.1.3.6)
// .iso.org.dod.internet (.1.3.6.1)
// .iso.org.dod.internet.mgmt (.1.3.6.1.2)
// .iso.org.dod.internet.mgmt.mib-2 (.1.3.6.1.2.1)
// .iso.org.dod.internet.mgmt.mib-2.system (.1.3.6.1.2.1.1)
// .iso.org.dod.internet.mgmt.mib-2.system.sysDescr (.1.3.6.1.2.1.1.1)
const char sysDescr[]    = "1.3.6.1.2.1.1.1.0";  // read-only  (DisplayString)
// .iso.org.dod.internet.mgmt.mib-2.system.sysObjectID (.1.3.6.1.2.1.1.2)
const char sysObjectID[] = "1.3.6.1.2.1.1.2.0";  // read-only  (ObjectIdentifier)
// .iso.org.dod.internet.mgmt.mib-2.system.sysUpTime (.1.3.6.1.2.1.1.3)
const char sysUpTime[]   = "1.3.6.1.2.1.1.3.0";  // read-only  (TimeTicks)
// .iso.org.dod.internet.mgmt.mib-2.system.sysContact (.1.3.6.1.2.1.1.4)
const char sysContact[]  = "1.3.6.1.2.1.1.4.0";  // read-write (DisplayString)
// .iso.org.dod.internet.mgmt.mib-2.system.sysName (.1.3.6.1.2.1.1.5)
const char sysName[]     = "1.3.6.1.2.1.1.5.0";  // read-write (DisplayString)
// .iso.org.dod.internet.mgmt.mib-2.system.sysLocation (.1.3.6.1.2.1.1.6)
const char sysLocation[] = "1.3.6.1.2.1.1.6.0";  // read-write (DisplayString)
// .iso.org.dod.internet.mgmt.mib-2.system.sysServices (.1.3.6.1.2.1.1.7)
const char sysServices[] = "1.3.6.1.2.1.1.7.0";  // read-only  (Integer)
//
// Arduino defined OIDs
// .iso.org.dod.internet.private (.1.3.6.1.4)
// .iso.org.dod.internet.private.enterprises (.1.3.6.1.4.1)
// .iso.org.dod.internet.private.enterprises.arduino (.1.3.6.1.4.1.36582)
const char enterprises[] = "1.3.6.1.4.1.36582.";  // read-only  (Integer)
//
//
// RFC1213 local values
static char locDescr[]              = "mbed Weather Platform";  // read-only (static)
static char locObjectID[]           = "1.3.6.1.4.1.36582";                       // read-only (static)
uint32_t locUpTime           = 0;                                        // read-only (static)
static char locContact[]            = "<root@weather>";                            // should be stored/read from EEPROM - read/write (not done for simplicity)
static char locName[]               = "weather.mbed";                              // should be stored/read from EEPROM - read/write (not done for simplicity)
static char locLocation[]           = "weather";                        // should be stored/read from EEPROM - read/write (not done for simplicity)
static int32_t locServices          = 7;                                        // read-only (static)

uint32_t prevMillis = 0;
char oid[SNMP_MAX_OID_LEN];
SNMP_API_STAT_CODES api_status;
SNMP_ERR_CODES status;

extern DigitalOut led_y;
extern Sensor sensor;

void pduReceived()
{
  SNMP_PDU pdu;
  //
  led_y = 1;
  api_status = Agentbed.requestPdu(&pdu);
  //
  if ( pdu.type == SNMP_PDU_GET || pdu.type == SNMP_PDU_GET_NEXT || pdu.type == SNMP_PDU_SET
    && pdu.error == SNMP_ERR_NO_ERROR && api_status == SNMP_API_STAT_SUCCESS ) {
    //
    pdu.OID.toString(oid);
    //
    pdu.error = SNMP_ERR_READ_ONLY;
    //
    if ( strcmp(oid, sysDescr ) == 0 ) {
      // handle sysDescr (set/get) requests
      if ( pdu.type == SNMP_PDU_GET ) {
        // response packet from get-request - locDescr
        status = pdu.VALUE.encode(SNMP_SYNTAX_OCTETS, locDescr);
        pdu.error = status;
      }
    } else if ( strcmp(oid, sysObjectID ) == 0 ) {
      // handle sysName (set/get) requests
      if ( pdu.type == SNMP_PDU_GET ) {
        // response packet from get-request - locUpTime
        status = pdu.VALUE.encode(SNMP_SYNTAX_OCTETS, locObjectID);
        pdu.error = status;
      }
    } else if ( strcmp(oid, sysUpTime ) == 0 ) {
      // handle sysName (set/get) requests
      if ( pdu.type == SNMP_PDU_GET ) {
        // response packet from get-request - locUpTime
        status = pdu.VALUE.encode(SNMP_SYNTAX_TIME_TICKS, locUpTime);
        pdu.error = status;
      }
    } else if ( strcmp(oid, sysName ) == 0 ) {
      // handle sysName (set/get) requests
      if ( pdu.type == SNMP_PDU_GET ) {
        // response packet from get-request - locName
        status = pdu.VALUE.encode(SNMP_SYNTAX_OCTETS, locName);
        pdu.error = status;
      }
    } else if ( strcmp(oid, sysContact ) == 0 ) {
      // handle sysContact (set/get) requests
      if ( pdu.type == SNMP_PDU_GET ) {
        // response packet from get-request - locContact
        status = pdu.VALUE.encode(SNMP_SYNTAX_OCTETS, locContact);
        pdu.error = status;
      }
    } else if ( strcmp(oid, sysLocation ) == 0 ) {
      // handle sysLocation (set/get) requests
      if ( pdu.type == SNMP_PDU_GET ) {
        // response packet from get-request - locLocation
        status = pdu.VALUE.encode(SNMP_SYNTAX_OCTETS, locLocation);
        pdu.error = status;
      }
    } else if ( strcmp(oid, sysServices) == 0 ) {
      // handle sysServices (set/get) requests
      if ( pdu.type == SNMP_PDU_GET ) {
        // response packet from get-request - locServices
        status = pdu.VALUE.encode(SNMP_SYNTAX_INT, locServices);
        pdu.error = status;
      }
    } else if ( strncmp(oid, enterprises, strlen(enterprises)) == 0 ) {
      // handle enterprises (set/get) requests
      if ( pdu.type == SNMP_PDU_GET ) {
        // response packet from get-request - enterprises
        switch (oid[strlen(enterprises)]) {
        case '0':
            status = pdu.VALUE.encode(SNMP_SYNTAX_OPAQUE_FLOAT, sensor.pres);
            break;
        case '1':
            status = pdu.VALUE.encode(SNMP_SYNTAX_OPAQUE_FLOAT, sensor.temp);
            break;
        case '2':
            status = pdu.VALUE.encode(SNMP_SYNTAX_OPAQUE_FLOAT, sensor.humi);
            break;
        case '3':
            status = pdu.VALUE.encode(SNMP_SYNTAX_OPAQUE_FLOAT, sensor.anemo);
            break;
        case '4':
            status = pdu.VALUE.encode(SNMP_SYNTAX_OPAQUE_FLOAT, sensor.vane);
            break;
        case '5':
            status = pdu.VALUE.encode(SNMP_SYNTAX_OPAQUE_FLOAT, sensor.rain);
            break;
        case '6':
            status = pdu.VALUE.encode(SNMP_SYNTAX_OPAQUE_FLOAT, sensor.light);
            break;
        case '7':
            status = pdu.VALUE.encode(SNMP_SYNTAX_OPAQUE_FLOAT, sensor.uv);
            break;
        case '8':
            status = pdu.VALUE.encode(SNMP_SYNTAX_OPAQUE_FLOAT, sensor.moist);
            break;
        case '9':
            status = pdu.VALUE.encode(SNMP_SYNTAX_OPAQUE_FLOAT, sensor.temp2);
            break;
        }
        pdu.error = status;
      }
    } else {
      // oid does not exist
      //
      // response packet - object not found
      pdu.error = SNMP_ERR_NO_SUCH_NAME;
    }
    //
    pdu.type = SNMP_PDU_RESPONSE;

    Agentbed.responsePdu(&pdu);
  }
  //
  Agentbed.freePdu(&pdu);
  //
  //Serial << "UDP Packet Received End.." << " RAM:" << freeMemory() << endl;
}
