/** @file
 * @brief mbed Weather Platform
 */
#include "mbed.h"
#include "EthernetNetIf.h"
#include "I2CLEDDisp.h"
#include "I2CLCD.h"

#define CONFIG_FILE "weather.cfg"


#define CF_MAXLEN_VALUE 128
#define CF_ACTION_EXPS 10
#define CF_ACTION_NUM 10
#define CF_TWITTER_NUM 5

enum eEXPRESSION {
    EXP_NULL,
    EXP_EQ,
    EXP_NE,
    EXP_LE,
    EXP_LT,
    EXP_GE,
    EXP_GT,
    EXP_MOD,
    EXP_NMOD,
    EXP_FALL,
    EXP_RISE,
};

enum eINPUTTYPE {
    INPUT_MOIST = 0,
    INPUT_FALL = 1,
    INPUT_RISE = 2,
    INPUT_CPM = 4,
};

struct tExpression {
    char key;
    enum eEXPRESSION expression;
    float value;
};

struct tAction {
    char action;
    char sub;
    int count;
    struct tExpression exps[CF_ACTION_EXPS];
};

struct Sensor {
    float pres, temp, humi, light, anemo, vane, rain, uv, moist, temp2;
};

struct Config {
    int interval;
    IpAddr ipaddr, netmask, gateway, nameserver;
    char ntpserver[32];
    int filetype, actionscount;
    struct tAction actions[CF_ACTION_NUM];
    char pachube_apikey[70], pachube_feedid[8];
    char twitter_user[30], twitter_pwd[30], twitter_mesg[CF_TWITTER_NUM][CF_MAXLEN_VALUE];
    char stations_id[8], stations_pin[34];
    char snmp_commname[30];
    char lcd_mesg[CF_MAXLEN_VALUE];
    enum I2CLCDType lcdtype;
    enum I2CLCDConfig lcdconf;
    char leddisp_mesg[CF_MAXLEN_VALUE];
    enum eINPUTTYPE inputtype;
};

int config (char *);
