/** @file
 * @brief mbed Weather Platform
 */
#include "mbed.h"
#include "conf.h"
#include "ConfigFile.h"

extern Serial xbee;
extern Config conf;
extern Sensor sensor, offset, sensor_old;

void int_counter();

char* chop (char *s) {
    int i;

    for (i = strlen(s) - 1; i >= 0; i --) {
        if (s[i] == ' ' || s[i] == '\n' || s[i] == '\r') {
            s[i] = 0;
        } else {
            break;
        }
    }
    return s;
}

int check_action (char type) {
    int i, j, count;
    float value, vold;
    time_t sec = time(NULL) + (60 * 60 * 9);
    struct tm *tim = localtime(&sec);

    for(i = 0; i < conf.actionscount; i ++) {
        if (conf.actions[i].action != type) continue;
        
        count = 0;
        for (j = 0; j < conf.actions[i].count; j ++) {
            switch (conf.actions[i].exps[j].key) {
            case 'P':
                value = sensor.pres;
                vold = sensor_old.pres;
                break;
            case 'T':
                value = sensor.temp;
                vold = sensor_old.temp;
                break;
            case 'H':
                value = sensor.humi;
                vold = sensor_old.humi;
                break;
            case 'A':
                value = sensor.anemo;
                vold = sensor_old.anemo;
                break;
            case 'V':
                value = sensor.vane;
                vold = sensor_old.vane;
                break;
            case 'R':
                value = sensor.rain;
                vold = sensor_old.rain;
                break;
            case 'L':
                value = sensor.light;
                vold = sensor_old.light;
                break;
            case 'U':
                value = sensor.uv;
                vold = sensor_old.uv;
                break;
            case 'M':
                value = sensor.moist;
                vold = sensor_old.moist;
                break;

            case 'y':
                value = tim->tm_year + 1900;
                break;
            case 'm':
                value = tim->tm_mon;
                break;
            case 'd':
                value = tim->tm_mday;
                break;
            case 'h':
                value = tim->tm_hour;
                break;
            case 'i':
                value = tim->tm_min;
                break;
            case 's':
                value = tim->tm_sec;
                break;

            default:
                value = 0;
                break;
            }

            switch (conf.actions[i].exps[j].expression) {
            case EXP_EQ:
                if (value == conf.actions[i].exps[j].value) {
                    count ++;
                }
                break;
            case EXP_NE:
                if (value != conf.actions[i].exps[j].value) {
                    count ++;
                }
                break;
            case EXP_LE:
                if (value <= conf.actions[i].exps[j].value) {
                    count ++;
                }
                break;
            case EXP_LT:
                if (value < conf.actions[i].exps[j].value) {
                    count ++;
                }
                break;
            case EXP_GE:
                if (value >= conf.actions[i].exps[j].value) {
                    count ++;
                }
                break;
            case EXP_GT:
                if (value > conf.actions[i].exps[j].value) {
                    count ++;
                }
                break;
            case EXP_MOD:
                if ((int)value % (int)conf.actions[i].exps[j].value) {
                    count ++;
                }
                break;
            case EXP_NMOD:
                if (! (int)value % (int)conf.actions[i].exps[j].value) {
                    count ++;
                }
                break;
            case EXP_FALL:
                if (value < conf.actions[i].exps[j].value && vold >= conf.actions[i].exps[j].value) {
                    count ++;
                }
                break;
            case EXP_RISE:
                if (value > conf.actions[i].exps[j].value && vold <= conf.actions[i].exps[j].value) {
                    count ++;
                }
                break;

            default:
                count ++;
                break;
            }
        }
        if (count == conf.actions[i].count) {
            return conf.actions[i].sub ? conf.actions[i].sub : ' ';
        }
    }
    return 0;
}

void add_actionsub (struct tExpression *exp, char *buf) {

    exp->key = buf[0];

    switch (buf[1]) {
    case '=':
        if (buf[2] == '=') {
            exp->expression = EXP_EQ;
            exp->value = atof(&buf[3]);
        }
        break;

    case '!':
        if (buf[2] == '=') {
            exp->expression = EXP_NE;
            exp->value = atof(&buf[3]);
        } else
        if (buf[2] == '%') {
            exp->expression = EXP_NMOD;
            exp->value = atof(&buf[3]);
        }
        break;

    case '<':
        if (buf[2] == '=') {
            exp->expression = EXP_LE;
            exp->value = atof(&buf[3]);
        } else {
            exp->expression = EXP_LT;
            exp->value = atof(&buf[2]);
        }
        break;

    case '>':
        if (buf[2] == '=') {
            exp->expression = EXP_GE;
            exp->value = atof(&buf[3]);
        } else {
            exp->expression = EXP_GT;
            exp->value = atof(&buf[2]);
        }
        break;
        
    case '%':
        exp->expression = EXP_MOD;
        exp->value = atof(&buf[2]);
        break;

    case '_':
        exp->expression = EXP_FALL;
        exp->value = atof(&buf[2]);
        break;
    case '^':
        exp->expression = EXP_RISE;
        exp->value = atof(&buf[2]);
        break;
       
    default:
        exp->expression = EXP_NULL;
        break;
    }
}

void add_action (char *buf) {
    int i, len, count;
    char c;
    char *tmp = NULL;

    if (conf.actionscount >= CF_ACTION_NUM) return;

//    conf.actions[conf.actionscount].action = atoi(&buf[0]);
    conf.actions[conf.actionscount].action = buf[0];
    conf.actions[conf.actionscount].sub = buf[1];

    count = 0;
    strcat(buf, "\n");
    len = strlen(buf);
    for (i = 1; i < len; i ++) {
        c = buf[i];
        if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            buf[i] = 0;
            if (count) {
                add_actionsub(&conf.actions[conf.actionscount].exps[count - 1], tmp);
            }
            if (count >= CF_ACTION_EXPS || c == '\n') break;
            tmp = &buf[i + 1];
            count ++;
        }
    }

    conf.actions[conf.actionscount].count = count;
    conf.actionscount ++;
}

int config (char *file) {
    int i;
    ConfigFile cfg;
    char buf[80], key[20];
    int ip0, ip1, ip2, ip3;
    
    conf.ipaddr = IpAddr(0, 0, 0, 0);
    conf.netmask = IpAddr(255, 255, 255, 0);
    conf.gateway = IpAddr(0, 0, 0, 0);
    conf.nameserver = IpAddr(0, 0, 0, 0);
    conf.interval = 60;
    conf.ntpserver[0] = 0;
    conf.filetype = 0;
    conf.actionscount = 0;
    conf.pachube_apikey[0] = 0;
    conf.pachube_feedid[0] = 0;
    conf.twitter_user[0] = 0;
    conf.twitter_pwd[0] = 0;
    for (i = 0; i < CF_TWITTER_NUM; i ++) {
        conf.twitter_mesg[i][0] = 0;
    }
    conf.stations_id[0] = 0;
    conf.stations_pin[0] = 0;
    conf.snmp_commname[0] = 0;
    conf.leddisp_mesg[0] = 0;
    conf.lcd_mesg[0] = 0;
    conf.lcdtype = LCD16x2;
    conf.lcdconf = LCDCFG_3V;
    memset(&offset, 0, sizeof(offset));
    memset(&sensor_old, 0, sizeof(sensor_old));

    if (! cfg.read(file)) {
        return -1;
    }

    if (cfg.getValue("INTERVAL", buf, sizeof(buf))) {
        conf.interval = atoi(chop(buf));
    }
    if (cfg.getValue("FILE", buf, sizeof(buf))) {
        chop(buf);
        if (strcmp(buf, "SD") == 0) {
            conf.filetype = 1;
        } else
        if (strcmp(buf, "USB") == 0) {
            conf.filetype = 2;
        }
    }

    if (cfg.getValue("IPADDRESS", buf, sizeof(buf))) {
        chop(buf);
        if (strcmp(buf, "DHCP") == 0) {
            conf.ipaddr = IpAddr(255, 255, 255, 255);
        } else {
            sscanf(buf, "%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
            conf.ipaddr = IpAddr(ip0, ip1, ip2, ip3);
        }
    }
    if (cfg.getValue("NETMASK", buf, sizeof(buf))) {
        sscanf(chop(buf), "%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
        conf.netmask = IpAddr(ip0, ip1, ip2, ip3);
    }
    if (cfg.getValue("GATEWAY", buf, sizeof(buf))) {
        sscanf(chop(buf), "%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
        conf.gateway = IpAddr(ip0, ip1, ip2, ip3);
    }
    if (cfg.getValue("NAMESERVER", buf, sizeof(buf))) {
        sscanf(chop(buf), "%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
        conf.nameserver = IpAddr(ip0, ip1, ip2, ip3);
    }

    cfg.getValue("NTPSERVER", conf.ntpserver, sizeof(conf.ntpserver));
    chop(conf.ntpserver);
    cfg.getValue("PACHUBE_APIKEY", conf.pachube_apikey, sizeof(conf.pachube_apikey));
    chop(conf.pachube_apikey);
    cfg.getValue("PACHUBE_FEEDID", conf.pachube_feedid, sizeof(conf.pachube_feedid));
    chop(conf.pachube_feedid);
    cfg.getValue("TWITTER_USER", conf.twitter_user, sizeof(conf.twitter_user));
    chop(conf.twitter_user);
    cfg.getValue("TWITTER_PWD", conf.twitter_pwd, sizeof(conf.twitter_pwd));
    chop(conf.twitter_pwd);
    cfg.getValue("TWITTER_MESG", conf.twitter_mesg[0], sizeof(conf.twitter_mesg[0]));
    chop(conf.twitter_mesg[0]);
    for (i = 0; i < CF_TWITTER_NUM; i ++) {
        sprintf(key, "TWITTER_MESG[%d]", i);
        cfg.getValue(key, conf.twitter_mesg[i], sizeof(conf.twitter_mesg[i]));
        chop(conf.twitter_mesg[i]);
    }

    cfg.getValue("STATIONS_ID", conf.stations_id, sizeof(conf.stations_id));
    chop(conf.stations_id);
    cfg.getValue("STATIONS_PIN", conf.stations_pin, sizeof(conf.stations_pin));
    chop(conf.stations_pin);
    cfg.getValue("SNMP_COMMNAME", conf.snmp_commname, sizeof(conf.snmp_commname));
    chop(conf.snmp_commname);

    if (cfg.getValue("LCD_TYPE", buf, sizeof(buf))) {
        conf.lcdtype = (enum I2CLCDType)atoi(chop(buf));
    }
    if (cfg.getValue("LCD_CONF", buf, sizeof(buf))) {
        conf.lcdconf = (enum I2CLCDConfig)atoi(chop(buf));
    }
    if (cfg.getValue("LCD_MESG", conf.lcd_mesg, sizeof(conf.lcd_mesg))) {
        chop(conf.lcd_mesg);
    }
    if (cfg.getValue("LEDDISP_MESG", conf.leddisp_mesg, sizeof(conf.leddisp_mesg))) {
        chop(conf.leddisp_mesg);
    }

    if (cfg.getValue("XBEE", buf, sizeof(buf))) {
        xbee.baud(atoi(chop(buf)));
    }

    if (cfg.getValue("INPUT", buf, sizeof(buf))) {
        conf.inputtype = (enum eINPUTTYPE)atoi(chop(buf));
    }

    for (i = 0; i < CF_ACTION_NUM; i ++) {
        sprintf(key, "ACTION[%d]", i);
        if (cfg.getValue(key, buf, sizeof(buf))) {
            add_action(chop(buf));
        }
    }

    if (cfg.getValue("OFFSET[P]", buf, sizeof(buf))) {
        offset.pres = atof(chop(buf));
    }
    if (cfg.getValue("OFFSET[T]", buf, sizeof(buf))) {
        offset.temp = atof(chop(buf));
    }
    if (cfg.getValue("OFFSET[H]", buf, sizeof(buf))) {
        offset.humi = atof(chop(buf));
    }

    return 0;
}
