/** @file
 * @brief mbed Weather Platform
 */
#include "mbed.h"
#include "EthernetNetIf.h"
#include "I2CLEDDisp.h"
#include "I2CLCD.h"
#include "Agentbed.h"
#include "NTPClient.h"
#include "HTTPClient.h"

#define DEBUG

#define CONFIG_FILE "weather.cfg"
#define ACTION_FILE "weather.asm"

#define CF_MAXLEN_VALUE 128
#define CF_ACTION_NUM 100
#define CF_TWITTER_NUM 5

#define INPUT_NUM 2
#define OUTPUT_NUM 10
#define TIMER_NUM 10
#define COUNTER_NUM 10

#define LED_FREQ 4 // x 0.1s

enum eMNEMONIC {
    MNE_NULL,
    MNE_DEF,
    MNE_LD, MNE_LDI, MNE_LDP, MNE_LDF,
    MNE_ALD, MNE_ALDI, MNE_ALDP, MNE_ALDF,
    MNE_OR, MNE_ORI, MNE_ORP, MNE_ORF,
    MNE_AND, MNE_ANI, MNE_ANDP, MNE_ANDF,
    MNE_ORB, MNE_ANB,
    MNE_INV,
    MNE_MPS, MNE_MRD, MNE_MPP,
    MNE_OUT, MNE_SET, MNE_RST,
    MNE_END,
};

enum eEXPRESSION {
    EXP_NULL,
    EXP_EQ, EXP_NE,
    EXP_LE, EXP_LT,
    EXP_GE, EXP_GT,
    EXP_MOD, EXP_NMOD,
};

enum eINPUTTYPE {
    INPUT_MOIST = 0,
    INPUT_FALL = 1,
    INPUT_RISE = 2,
    INPUT_CPM = 4,
};

struct tAction {
    enum eMNEMONIC mnemonic;
    char key;
    int keynum;
    enum eEXPRESSION expression;
    float value;
};

struct Sensor {
    float pres, temp, humi, light, anemo, vane, rain, uv, moist, temp2;
    time_t sec;
    int input[INPUT_NUM], output[OUTPUT_NUM];
    int timer_flg[TIMER_NUM];
    unsigned int timer_set[TIMER_NUM], timer_cnt[TIMER_NUM];
    unsigned int count_set[COUNTER_NUM], count_cnt[COUNTER_NUM], count_rev[COUNTER_NUM];
};

struct Config {
    int interval;
    IpAddr ipaddr, netmask, gateway, nameserver;
    char ntpserver[32];
    int filetype, actionscount;
    struct tAction actions[CF_ACTION_NUM];
    char pachube_apikey[70], pachube_feedid[8];
    char twitter_user[30], twitter_pwd[30], twitter_mesg[CF_TWITTER_NUM][CF_MAXLEN_VALUE];
    char stations_id[8], stations_pin[34];
    char snmp_commname[30];
    char lcd_mesg[CF_MAXLEN_VALUE];
    enum I2CLCDType lcdtype;
    enum I2CLCDConfig lcdconf;
    char leddisp_mesg[CF_MAXLEN_VALUE];
    enum eINPUTTYPE inputtype;
};


extern char filename[];
extern char csv[];
extern AgentbedClass Agentbed;
extern volatile uint32_t locUpTime;
extern Serial xbee;
extern Config conf;
extern Sensor sensor, offset, sensor_old;
extern Serial pc;
extern volatile int seq;
extern DigitalOut led1, led2, led3, led4;
extern AnalogIn *aimoist;
extern DigitalIn swin2;
extern DigitalOut swout1, swout2;
extern EthernetNetIf *eth; 
extern NTPClient *ntp;
extern HTTPClient *clientP, *clientT;
extern DigitalOut led_g2, led_g, led_y;


int config (char *);
void writefile (char *);
void pachube (char *);
char *fmtstr (char *, char *, int);
void twitter (int);
void weatherstations ();
void ntpdate ();
int check_action (char);
void pduReceived ();
void int_counter();
int action(char);
void load_action (char *);

