/** @file
 * @brief mbed Weather Platform
 */
#include "mbed.h"
#include "weather.h"
#include "ConfigFile.h"


char* chop (char *s) {
    int i;

    for (i = strlen(s) - 1; i >= 0; i --) {
        if (s[i] == ' ' || s[i] == '\n' || s[i] == '\r') {
            s[i] = 0;
        } else {
            break;
        }
    }
    return s;
}

int config (char *file) {
    int i;
    ConfigFile cfg;
    char buf[80], key[20];
    int ip0, ip1, ip2, ip3;
    
    conf.ipaddr = IpAddr(0, 0, 0, 0);
    conf.netmask = IpAddr(255, 255, 255, 0);
    conf.gateway = IpAddr(0, 0, 0, 0);
    conf.nameserver = IpAddr(0, 0, 0, 0);
    conf.interval = 60;
    conf.ntpserver[0] = 0;
    conf.filetype = 0;
    conf.actionscount = 0;
    conf.pachube_apikey[0] = 0;
    conf.pachube_feedid[0] = 0;
    conf.twitter_user[0] = 0;
    conf.twitter_pwd[0] = 0;
    for (i = 0; i < CF_TWITTER_NUM; i ++) {
        conf.twitter_mesg[i][0] = 0;
    }
    conf.stations_id[0] = 0;
    conf.stations_pin[0] = 0;
    conf.snmp_commname[0] = 0;
    conf.leddisp_mesg[0] = 0;
    conf.lcd_mesg[0] = 0;
    conf.lcdtype = LCD16x2;
    conf.lcdconf = LCDCFG_3V;
    memset(&offset, 0, sizeof(offset));
    memset(&sensor_old, 0, sizeof(sensor_old));

    if (! cfg.read(file)) {
        return -1;
    }

    if (cfg.getValue("INTERVAL", buf, sizeof(buf))) {
        conf.interval = atoi(chop(buf));
    }
    if (cfg.getValue("FILE", buf, sizeof(buf))) {
        chop(buf);
        if (strcmp(buf, "SD") == 0) {
            conf.filetype = 1;
        } else
        if (strcmp(buf, "USB") == 0) {
            conf.filetype = 2;
        }
    }

    if (cfg.getValue("IPADDRESS", buf, sizeof(buf))) {
        chop(buf);
        if (strcmp(buf, "DHCP") == 0) {
            conf.ipaddr = IpAddr(255, 255, 255, 255);
        } else {
            sscanf(buf, "%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
            conf.ipaddr = IpAddr(ip0, ip1, ip2, ip3);
        }
    }
    if (cfg.getValue("NETMASK", buf, sizeof(buf))) {
        sscanf(chop(buf), "%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
        conf.netmask = IpAddr(ip0, ip1, ip2, ip3);
    }
    if (cfg.getValue("GATEWAY", buf, sizeof(buf))) {
        sscanf(chop(buf), "%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
        conf.gateway = IpAddr(ip0, ip1, ip2, ip3);
    }
    if (cfg.getValue("NAMESERVER", buf, sizeof(buf))) {
        sscanf(chop(buf), "%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
        conf.nameserver = IpAddr(ip0, ip1, ip2, ip3);
    }

    cfg.getValue("NTPSERVER", conf.ntpserver, sizeof(conf.ntpserver));
    chop(conf.ntpserver);
    cfg.getValue("PACHUBE_APIKEY", conf.pachube_apikey, sizeof(conf.pachube_apikey));
    chop(conf.pachube_apikey);
    cfg.getValue("PACHUBE_FEEDID", conf.pachube_feedid, sizeof(conf.pachube_feedid));
    chop(conf.pachube_feedid);
    cfg.getValue("TWITTER_USER", conf.twitter_user, sizeof(conf.twitter_user));
    chop(conf.twitter_user);
    cfg.getValue("TWITTER_PWD", conf.twitter_pwd, sizeof(conf.twitter_pwd));
    chop(conf.twitter_pwd);
    cfg.getValue("TWITTER_MESG", conf.twitter_mesg[0], sizeof(conf.twitter_mesg[0]));
    chop(conf.twitter_mesg[0]);
    for (i = 0; i < CF_TWITTER_NUM; i ++) {
        sprintf(key, "TWITTER_MESG[%d]", i);
        cfg.getValue(key, conf.twitter_mesg[i], sizeof(conf.twitter_mesg[i]));
        chop(conf.twitter_mesg[i]);
    }

    cfg.getValue("STATIONS_ID", conf.stations_id, sizeof(conf.stations_id));
    chop(conf.stations_id);
    cfg.getValue("STATIONS_PIN", conf.stations_pin, sizeof(conf.stations_pin));
    chop(conf.stations_pin);
    cfg.getValue("SNMP_COMMNAME", conf.snmp_commname, sizeof(conf.snmp_commname));
    chop(conf.snmp_commname);

    if (cfg.getValue("LCD_TYPE", buf, sizeof(buf))) {
        conf.lcdtype = (enum I2CLCDType)atoi(chop(buf));
    }
    if (cfg.getValue("LCD_CONF", buf, sizeof(buf))) {
        conf.lcdconf = (enum I2CLCDConfig)atoi(chop(buf));
    }
    if (cfg.getValue("LCD_MESG", conf.lcd_mesg, sizeof(conf.lcd_mesg))) {
        chop(conf.lcd_mesg);
    }
    if (cfg.getValue("LEDDISP_MESG", conf.leddisp_mesg, sizeof(conf.leddisp_mesg))) {
        chop(conf.leddisp_mesg);
    }

    if (cfg.getValue("XBEE", buf, sizeof(buf))) {
        xbee.baud(atoi(chop(buf)));
    }

    if (cfg.getValue("INPUT", buf, sizeof(buf))) {
        conf.inputtype = (enum eINPUTTYPE)atoi(chop(buf));
    }

    if (cfg.getValue("OFFSET[P]", buf, sizeof(buf))) {
        offset.pres = atof(chop(buf));
    }
    if (cfg.getValue("OFFSET[T]", buf, sizeof(buf))) {
        offset.temp = atof(chop(buf));
    }
    if (cfg.getValue("OFFSET[H]", buf, sizeof(buf))) {
        offset.humi = atof(chop(buf));
    }

    return 0;
}
